/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.CorruptStateException;

public final class ChecksumBlobStoreFormat<T extends ToXContent> {
    public static final ToXContent.Params SNAPSHOT_ONLY_FORMAT_PARAMS;
    public static final int VERSION = 1;
    private static final int BUFFER_SIZE = 4096;
    private final String codec;
    private final String blobNameFormat;
    private final CheckedFunction<XContentParser, T, IOException> reader;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> reader) {
        this.reader = reader;
        this.blobNameFormat = blobNameFormat;
        this.codec = codec;
    }

    public T read(BlobContainer blobContainer, String name, NamedXContentRegistry namedXContentRegistry, BigArrays bigArrays) throws IOException {
        String blobName = this.blobName(name);
        try (ReleasableBytesStreamOutput out = new ReleasableBytesStreamOutput(bigArrays);){
            T t;
            block11: {
                InputStream in = blobContainer.readBlob(blobName);
                try {
                    org.elasticsearch.core.internal.io.Streams.copy((InputStream)in, (OutputStream)out, (boolean)false);
                    t = this.deserialize(blobName, namedXContentRegistry, out.bytes());
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return t;
        }
    }

    public String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String blobName, NamedXContentRegistry namedXContentRegistry, BytesReference bytes) throws IOException {
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try {
            Object indexInput = bytes.length() > 0 ? new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(BytesReference.toByteBuffers(bytes))), resourceDesc) : new ByteArrayIndexInput(resourceDesc, BytesRef.EMPTY_BYTES);
            CodecUtil.checksumEntireFile((IndexInput)indexInput);
            CodecUtil.checkHeader((DataInput)indexInput, (String)this.codec, (int)1, (int)1);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            try (XContentParser parser = XContentHelper.createParser(namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, bytes.slice((int)filePointer, (int)contentSize), XContentType.SMILE);){
                ToXContent toXContent = (ToXContent)this.reader.apply((Object)parser);
                return (T)toXContent;
            }
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }

    public void write(T obj, BlobContainer blobContainer, String name, boolean compress, BigArrays bigArrays) throws IOException {
        String blobName = this.blobName(name);
        this.serialize(obj, blobName, compress, bigArrays, (CheckedConsumer<BytesReference, IOException>)((CheckedConsumer)bytes -> blobContainer.writeBlob(blobName, bytes.streamInput(), bytes.length(), false)));
    }

    public void serialize(T obj, String blobName, boolean compress, BigArrays bigArrays, CheckedConsumer<BytesReference, IOException> consumer) throws IOException {
        try (ReleasableBytesStreamOutput outputStream = new ReleasableBytesStreamOutput(bigArrays);){
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")", blobName, Streams.noCloseStream(outputStream), 4096);){
                CodecUtil.writeHeader((DataOutput)indexOutput, (String)this.codec, (int)1);
                try (IndexOutputOutputStream indexOutputOutputStream = new IndexOutputOutputStream((IndexOutput)indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };
                     XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.SMILE, (OutputStream)(compress ? CompressorFactory.COMPRESSOR.threadLocalOutputStream(indexOutputOutputStream) : indexOutputOutputStream));){
                    builder.startObject();
                    obj.toXContent(builder, SNAPSHOT_ONLY_FORMAT_PARAMS);
                    builder.endObject();
                }
                CodecUtil.writeFooter((IndexOutput)indexOutput);
            }
            consumer.accept((Object)outputStream.bytes());
        }
    }

    static {
        HashMap<String, String> snapshotOnlyParams = new HashMap<String, String>();
        snapshotOnlyParams.put("context_mode", Metadata.CONTEXT_MODE_SNAPSHOT);
        snapshotOnlyParams.put("context_mode", "SNAPSHOT");
        SNAPSHOT_ONLY_FORMAT_PARAMS = new ToXContent.MapParams(snapshotOnlyParams);
    }
}

