/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.AbstractPercentilesAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregatorFactory;
import org.elasticsearch.search.aggregations.metrics.PercentilesAggregatorSupplier;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class PercentilesAggregationBuilder
extends AbstractPercentilesAggregationBuilder<PercentilesAggregationBuilder> {
    public static final String NAME = "percentiles";
    public static final ValuesSourceRegistry.RegistryKey<PercentilesAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<PercentilesAggregatorSupplier>("percentiles", PercentilesAggregatorSupplier.class);
    private static final double[] DEFAULT_PERCENTS = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
    private static final ParseField PERCENTS_FIELD = new ParseField("percents", new String[0]);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(PercentilesAggregationBuilder.class);
    private static final ConstructingObjectParser<PercentilesAggregationBuilder, String> PARSER = AbstractPercentilesAggregationBuilder.createParser("percentiles", (name, values, percentileConfig) -> {
        values = values == null ? DEFAULT_PERCENTS : PercentilesAggregationBuilder.validatePercentiles(values, name);
        return new PercentilesAggregationBuilder((String)name, (double[])values, (PercentilesConfig)percentileConfig);
    }, PercentilesConfig.TDigest::new, PERCENTS_FIELD);

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        PercentilesAggregatorFactory.registerAggregators(builder);
    }

    public PercentilesAggregationBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (AggregationBuilder)PARSER.parse(parser, (Object)aggregationName);
    }

    public PercentilesAggregationBuilder(String name) {
        this(name, DEFAULT_PERCENTS, null);
    }

    public PercentilesAggregationBuilder(String name, double[] values, PercentilesConfig percentilesConfig) {
        super(name, values, percentilesConfig, PERCENTS_FIELD);
    }

    protected PercentilesAggregationBuilder(PercentilesAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new PercentilesAggregationBuilder(this, factoriesBuilder, metadata);
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    public PercentilesAggregationBuilder percentiles(double ... percents) {
        this.values = PercentilesAggregationBuilder.validatePercentiles(percents, this.name);
        return this;
    }

    private static double[] validatePercentiles(double[] percents, String aggName) {
        if (percents == null) {
            throw new IllegalArgumentException("[percents] must not be null: [" + aggName + "]");
        }
        if (percents.length == 0) {
            throw new IllegalArgumentException("[percents] must not be empty: [" + aggName + "]");
        }
        double[] sortedPercents = Arrays.copyOf(percents, percents.length);
        double previousPercent = -1.0;
        Arrays.sort(sortedPercents);
        for (double percent : sortedPercents) {
            if (percent < 0.0 || percent > 100.0) {
                throw new IllegalArgumentException("percent must be in [0,100], got [" + percent + "]: [" + aggName + "]");
            }
            if (percent == previousPercent) {
                deprecationLogger.deprecate("percents", "percent [{}] has been specified more than once, percents must be unique", percent);
            }
            previousPercent = percent;
        }
        return sortedPercents;
    }

    public double[] percentiles() {
        return this.values;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        PercentilesAggregatorSupplier aggregatorSupplier = context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        return new PercentilesAggregatorFactory(this.name, config, this.values, this.configOrDefault(), this.keyed, context, parent, subFactoriesBuilder, this.metadata, aggregatorSupplier);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }
}

