/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.support.AggregationUsageService;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.elasticsearch.search.profile.aggregation.ProfilingAggregator;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;

public abstract class AggregationContext {
    public abstract Query query();

    public abstract Aggregator profileIfEnabled(Aggregator var1) throws IOException;

    public abstract boolean profiling();

    public abstract long nowInMillis();

    public final FieldContext buildFieldContext(String field) {
        MappedFieldType ft = this.getFieldType(field);
        if (ft == null) {
            return null;
        }
        return new FieldContext(field, this.buildFieldData(ft), ft);
    }

    public final FieldContext buildFieldContext(MappedFieldType ft) {
        return new FieldContext(ft.name(), this.buildFieldData(ft), ft);
    }

    protected abstract IndexFieldData<?> buildFieldData(MappedFieldType var1);

    public abstract MappedFieldType getFieldType(String var1);

    public abstract boolean isFieldMapped(String var1);

    public abstract <FactoryType> FactoryType compile(Script var1, ScriptContext<FactoryType> var2);

    public abstract SearchLookup lookup();

    public abstract ValuesSourceRegistry getValuesSourceRegistry();

    public final AggregationUsageService getUsageService() {
        return this.getValuesSourceRegistry().getUsageService();
    }

    public abstract BigArrays bigArrays();

    public abstract IndexSearcher searcher();

    public abstract Query buildQuery(QueryBuilder var1) throws IOException;

    public abstract IndexSettings getIndexSettings();

    public abstract Optional<SortAndFormats> buildSort(List<SortBuilder<?>> var1) throws IOException;

    public abstract ObjectMapper getObjectMapper(String var1);

    public abstract NestedScope nestedScope();

    public abstract SubSearchContext subSearchContext();

    public abstract void addReleasable(Aggregator var1);

    public abstract MultiBucketConsumerService.MultiBucketConsumer multiBucketConsumer();

    public abstract BitsetFilterCache bitsetFilterCache();

    public abstract BucketedSort buildBucketedSort(SortBuilder<?> var1, int var2, BucketedSort.ExtraData var3) throws IOException;

    public abstract int shardRandomSeed();

    public abstract long getRelativeTimeInMillis();

    public abstract boolean isCancelled();

    public abstract CircuitBreaker breaker();

    public abstract Analyzer getIndexAnalyzer(Function<String, NamedAnalyzer> var1);

    public abstract Version indexVersionCreated();

    public abstract boolean isCacheable();

    public static class ProductionAggregationContext
    extends AggregationContext {
        private final QueryShardContext context;
        private final BigArrays bigArrays;
        private final Supplier<Query> topLevelQuery;
        private final AggregationProfiler profiler;
        private final MultiBucketConsumerService.MultiBucketConsumer multiBucketConsumer;
        private final Supplier<SubSearchContext> subSearchContextBuilder;
        private final Consumer<Aggregator> addReleasable;
        private final BitsetFilterCache bitsetFilterCache;
        private final int randomSeed;
        private final LongSupplier relativeTimeInMillis;
        private final Supplier<Boolean> isCancelled;

        public ProductionAggregationContext(QueryShardContext context, Supplier<Query> topLevelQuery, @Nullable AggregationProfiler profiler, MultiBucketConsumerService.MultiBucketConsumer multiBucketConsumer, Supplier<SubSearchContext> subSearchContextBuilder, Consumer<Aggregator> addReleasable, BitsetFilterCache bitsetFilterCache, int randomSeed, LongSupplier relativeTimeInMillis, Supplier<Boolean> isCancelled) {
            this.context = context;
            this.bigArrays = context.bigArrays().withCircuitBreaking();
            this.topLevelQuery = topLevelQuery;
            this.profiler = profiler;
            this.multiBucketConsumer = multiBucketConsumer;
            this.subSearchContextBuilder = subSearchContextBuilder;
            this.addReleasable = addReleasable;
            this.bitsetFilterCache = bitsetFilterCache;
            this.randomSeed = randomSeed;
            this.relativeTimeInMillis = relativeTimeInMillis;
            this.isCancelled = isCancelled;
        }

        @Override
        public Query query() {
            return this.topLevelQuery.get();
        }

        @Override
        public Aggregator profileIfEnabled(Aggregator agg) throws IOException {
            if (this.profiler == null) {
                return agg;
            }
            return new ProfilingAggregator(agg, this.profiler);
        }

        @Override
        public boolean profiling() {
            return this.profiler != null;
        }

        @Override
        public long nowInMillis() {
            return this.context.nowInMillis();
        }

        @Override
        protected IndexFieldData<?> buildFieldData(MappedFieldType ft) {
            return this.context.getForField(ft);
        }

        @Override
        public MappedFieldType getFieldType(String path) {
            return this.context.getFieldType(path);
        }

        @Override
        public boolean isFieldMapped(String field) {
            return this.context.isFieldMapped(field);
        }

        @Override
        public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> scriptContext) {
            return this.context.compile(script, scriptContext);
        }

        @Override
        public SearchLookup lookup() {
            return this.context.lookup();
        }

        @Override
        public ValuesSourceRegistry getValuesSourceRegistry() {
            return this.context.getValuesSourceRegistry();
        }

        @Override
        public BigArrays bigArrays() {
            return this.bigArrays;
        }

        @Override
        public IndexSearcher searcher() {
            return this.context.searcher();
        }

        @Override
        public Query buildQuery(QueryBuilder builder) throws IOException {
            return Rewriteable.rewrite(builder, this.context, true).toQuery(this.context);
        }

        @Override
        public IndexSettings getIndexSettings() {
            return this.context.getIndexSettings();
        }

        @Override
        public Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sortBuilders) throws IOException {
            return SortBuilder.buildSort(sortBuilders, this.context);
        }

        @Override
        public ObjectMapper getObjectMapper(String path) {
            return this.context.getObjectMapper(path);
        }

        @Override
        public NestedScope nestedScope() {
            return this.context.nestedScope();
        }

        @Override
        public SubSearchContext subSearchContext() {
            return this.subSearchContextBuilder.get();
        }

        @Override
        public void addReleasable(Aggregator aggregator) {
            this.addReleasable.accept(aggregator);
        }

        @Override
        public MultiBucketConsumerService.MultiBucketConsumer multiBucketConsumer() {
            return this.multiBucketConsumer;
        }

        @Override
        public BitsetFilterCache bitsetFilterCache() {
            return this.bitsetFilterCache;
        }

        @Override
        public BucketedSort buildBucketedSort(SortBuilder<?> sort, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
            return sort.buildBucketedSort(this.context, bucketSize, extra);
        }

        @Override
        public int shardRandomSeed() {
            return this.randomSeed;
        }

        @Override
        public long getRelativeTimeInMillis() {
            return this.relativeTimeInMillis.getAsLong();
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled.get();
        }

        @Override
        public CircuitBreaker breaker() {
            return this.context.bigArrays().breakerService().getBreaker("request");
        }

        @Override
        public Analyzer getIndexAnalyzer(Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
            return this.context.getIndexAnalyzer(unindexedFieldAnalyzer);
        }

        @Override
        public Version indexVersionCreated() {
            return this.context.indexVersionCreated();
        }

        @Override
        public boolean isCacheable() {
            return this.context.isCacheable();
        }
    }
}

