/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.slice;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.slice.DocValuesSliceQuery;
import org.elasticsearch.search.slice.TermsSliceQuery;

public class SliceBuilder
implements Writeable,
ToXContentObject {
    private static final DeprecationLogger DEPRECATION_LOG = DeprecationLogger.getLogger(SliceBuilder.class);
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    public static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    private static final ObjectParser<SliceBuilder, Void> PARSER = new ObjectParser("slice", SliceBuilder::new);
    private String field = "_id";
    private int id = -1;
    private int max = -1;

    private SliceBuilder() {
    }

    public SliceBuilder(int id, int max) {
        this("_id", id, max);
    }

    public SliceBuilder(String field, int id, int max) {
        this.setField(field);
        this.setId(id);
        this.setMax(max);
    }

    public SliceBuilder(StreamInput in) throws IOException {
        String field = in.readString();
        if ("_uid".equals(field) && in.getVersion().before(Version.V_6_3_0)) {
            field = "_id";
        }
        this.field = field;
        this.id = in.readVInt();
        this.max = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if ("_id".equals(this.field) && out.getVersion().before(Version.V_6_3_0)) {
            out.writeString("_uid");
        } else {
            out.writeString(this.field);
        }
        out.writeVInt(this.id);
        out.writeVInt(this.max);
    }

    private SliceBuilder setField(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.field = field;
        return this;
    }

    public String getField() {
        return this.field;
    }

    private SliceBuilder setId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be greater than or equal to 0");
        }
        if (this.max != -1 && id >= this.max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    private SliceBuilder setMax(int max) {
        if (max <= 1) {
            throw new IllegalArgumentException("max must be greater than 1");
        }
        if (this.id != -1 && this.id >= max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.max = max;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    void innerToXContent(XContentBuilder builder) throws IOException {
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(MAX_FIELD.getPreferredName(), this.max);
    }

    public static SliceBuilder fromXContent(XContentParser parser) throws IOException {
        SliceBuilder builder = (SliceBuilder)PARSER.parse(parser, (Object)new SliceBuilder(), null);
        return builder;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SliceBuilder)) {
            return false;
        }
        SliceBuilder o = (SliceBuilder)other;
        return (this.field == null && o.field == null || this.field.equals(o.field)) && this.id == o.id && o.max == this.max;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.id, this.max);
    }

    public Query toFilter(ShardSearchRequest request, QueryShardContext context) {
        MappedFieldType type = context.getFieldType(this.field);
        if (type == null) {
            throw new IllegalArgumentException("field " + this.field + " not found");
        }
        int shardIndex = request.shardIndex() != -1 ? request.shardIndex() : request.shardId().id();
        int numShards = request.shardIndex() != -1 ? request.numberOfShards() : context.getIndexSettings().getNumberOfShards();
        String field = this.field;
        boolean useTermQuery = false;
        if ("_uid".equals(field)) {
            field = "_id";
            if (context.getIndexSettings().getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("Computing slices on the [_uid] field is illegal for 7.x indices, use [_id] instead");
            }
            DEPRECATION_LOG.deprecate("slice_on_uid", "Computing slices on the [_uid] field is deprecated for 6.x indices, use [_id] instead", new Object[0]);
            useTermQuery = true;
        } else if ("_id".equals(field)) {
            useTermQuery = true;
        } else {
            if (!type.hasDocValues()) {
                throw new IllegalArgumentException("cannot load numeric doc values on " + field);
            }
            Object ifm = context.getForField(type);
            if (!(ifm instanceof IndexNumericFieldData)) {
                throw new IllegalArgumentException("cannot load numeric doc values on " + field);
            }
        }
        if (numShards == 1) {
            return useTermQuery ? new TermsSliceQuery(field, this.id, this.max) : new DocValuesSliceQuery(field, this.id, this.max);
        }
        if (this.max >= numShards) {
            int targetShard = this.id % numShards;
            if (targetShard != shardIndex) {
                return new MatchNoDocsQuery("this shard is not part of the slice");
            }
            int numSlicesInShard = this.max / numShards;
            int rest = this.max % numShards;
            if (rest > targetShard) {
                ++numSlicesInShard;
            }
            if (numSlicesInShard == 1) {
                return new MatchAllDocsQuery();
            }
            int shardSlice = this.id / numShards;
            return useTermQuery ? new TermsSliceQuery(field, shardSlice, numSlicesInShard) : new DocValuesSliceQuery(field, shardSlice, numSlicesInShard);
        }
        int targetSlice = shardIndex % this.max;
        if (this.id != targetSlice) {
            return new MatchNoDocsQuery("this shard is not part of the slice");
        }
        return new MatchAllDocsQuery();
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    static {
        PARSER.declareString(SliceBuilder::setField, FIELD_FIELD);
        PARSER.declareInt(SliceBuilder::setId, ID_FIELD);
        PARSER.declareInt(SliceBuilder::setMax, MAX_FIELD);
    }
}

