/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

public class MetaDataIndexAliasesService {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AliasValidator aliasValidator;
    private final MetaDataDeleteIndexService deleteIndexService;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public MetaDataIndexAliasesService(ClusterService clusterService, IndicesService indicesService, AliasValidator aliasValidator, MetaDataDeleteIndexService deleteIndexService, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.aliasValidator = aliasValidator;
        this.deleteIndexService = deleteIndexService;
        this.xContentRegistry = xContentRegistry;
    }

    public void indicesAliases(final IndicesAliasesClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return MetaDataIndexAliasesService.this.innerExecute(currentState, request.actions());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState innerExecute(ClusterState currentState, Iterable<AliasAction> actions) {
        ArrayList indicesToClose = new ArrayList();
        HashMap indices = new HashMap();
        try {
            ClusterState updatedState;
            boolean changed = false;
            HashSet<Index> indicesToDelete = new HashSet<Index>();
            for (AliasAction action : actions) {
                if (!action.removeIndex()) continue;
                IndexMetaData index = currentState.metaData().getIndices().get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                indicesToDelete.add(index.getIndex());
                changed = true;
            }
            if (changed) {
                currentState = this.deleteIndexService.deleteIndices(currentState, indicesToDelete);
            }
            MetaData.Builder metadata = MetaData.builder(currentState.metaData());
            HashSet<String> maybeModifiedIndices = new HashSet<String>();
            for (AliasAction action : actions) {
                if (action.removeIndex()) continue;
                Writeable index = metadata.get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                AliasAction.NewAliasValidator newAliasValidator = (arg_0, arg_1, arg_2, arg_3) -> this.lambda$innerExecute$2(metadata, action, indices, (IndexMetaData)index, indicesToClose, arg_0, arg_1, arg_2, arg_3);
                if (!action.apply(newAliasValidator, metadata, (IndexMetaData)index)) continue;
                changed = true;
                maybeModifiedIndices.add(((IndexMetaData)index).getIndex().getName());
            }
            for (String maybeModifiedIndex : maybeModifiedIndices) {
                IndexMetaData currentIndexMetaData = currentState.metaData().index(maybeModifiedIndex);
                IndexMetaData newIndexMetaData = metadata.get(maybeModifiedIndex);
                if (currentIndexMetaData.getAliases().equals(newIndexMetaData.getAliases())) continue;
                assert (currentIndexMetaData.getAliasesVersion() == newIndexMetaData.getAliasesVersion());
                metadata.put(new IndexMetaData.Builder(newIndexMetaData).aliasesVersion(1L + currentIndexMetaData.getAliasesVersion()));
            }
            if (changed && !(updatedState = ClusterState.builder(currentState).metaData(metadata).build()).metaData().equalsAliases(currentState.metaData())) {
                ClusterState clusterState = updatedState;
                return clusterState;
            }
            ClusterState clusterState = currentState;
            return clusterState;
        }
        finally {
            for (Index index : indicesToClose) {
                this.indicesService.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "created for alias processing");
            }
        }
    }

    private /* synthetic */ void lambda$innerExecute$2(MetaData.Builder metadata, AliasAction action, Map indices, IndexMetaData index, List indicesToClose, String alias, String indexRouting, String filter, Boolean writeIndex) {
        Function<String, IndexMetaData> indexLookup = name -> metadata.get((String)name);
        this.aliasValidator.validateAlias(alias, action.getIndex(), indexRouting, indexLookup);
        if (Strings.hasLength(filter)) {
            IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = (IndexService)indices.get(index.getIndex().getName());
            if (indexService == null) {
                indexService = this.indicesService.indexService(index.getIndex());
                if (indexService == null) {
                    try {
                        indexService = this.indicesService.createIndex(index, Collections.emptyList());
                        indicesToClose.add(index.getIndex());
                    }
                    catch (IOException e) {
                        throw new ElasticsearchException("Failed to create temporary index for parsing the alias", (Throwable)e, new Object[0]);
                    }
                    ((IndexService)indexService).mapperService().merge(index, MapperService.MergeReason.MAPPING_RECOVERY);
                }
                indices.put(action.getIndex(), indexService);
            }
            this.aliasValidator.validateAliasFilter(alias, filter, ((IndexService)indexService).newQueryShardContext(0, null, () -> 0L, null), this.xContentRegistry);
        }
    }
}

