/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jboss.byteman.agent.Location;
import org.jboss.byteman.agent.LocationType;
import org.jboss.byteman.agent.Transform;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.type.TypeHelper;

public class RuleScript {
    private String name;
    private String targetClass;
    private boolean isInterface;
    private String targetMethod;
    private boolean isOverride;
    private String targetHelper;
    private String[] imports;
    private Location targetLocation;
    private String ruleText;
    private boolean deleted;
    private int line;
    private String file;
    private final boolean compileToBytecode;
    private List<Transform> transformed;

    public RuleScript(String name, String targetClass, boolean isInterface, boolean isOverride, String targetMethod, String targetHelper, String[] imports, Location targetLocation, String ruleText, int line, String file, boolean compileToBytecode) {
        this.name = name;
        this.targetClass = targetClass;
        this.isInterface = isInterface;
        this.isOverride = isOverride;
        this.targetMethod = targetMethod;
        this.targetHelper = targetHelper;
        this.imports = imports;
        this.targetLocation = targetLocation != null ? targetLocation : Location.create(LocationType.ENTRY, "");
        this.ruleText = ruleText;
        this.line = line;
        this.file = file;
        this.compileToBytecode = compileToBytecode;
        this.transformed = new ArrayList<Transform>();
    }

    public String getName() {
        return this.name;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public String getTargetHelper() {
        return this.targetHelper;
    }

    public String[] getImports() {
        return this.imports;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public String getRuleText() {
        return this.ruleText;
    }

    public int getLine() {
        return this.line;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isCompileToBytecode() {
        return this.compileToBytecode;
    }

    public List<Transform> getTransformed() {
        return this.transformed;
    }

    public int getTransformedCount() {
        return this.transformed != null ? this.transformed.size() : 0;
    }

    public synchronized boolean setDeleted() {
        if (!this.deleted) {
            this.deleted = true;
            return false;
        }
        return true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public synchronized boolean recordFailedTransform(ClassLoader loader, String internalClassName, Throwable th) {
        return this.recordTransform(loader, internalClassName, null, null, null, th);
    }

    public synchronized boolean recordMethodTransform(ClassLoader loader, String internalClassName, String triggerMethodName, String desc, Rule rule) {
        return this.recordTransform(loader, internalClassName, triggerMethodName, desc, rule, null);
    }

    public synchronized boolean recordTransform(ClassLoader loader, String internalClassName, String triggerMethodName, String desc, Rule rule, Throwable th) {
        if (this.deleted) {
            return false;
        }
        String fullMethodName = null;
        if (triggerMethodName != null) {
            fullMethodName = triggerMethodName + TypeHelper.internalizeDescriptor(desc);
        }
        this.transformed.add(new Transform(loader, internalClassName, fullMethodName, rule, th));
        return true;
    }

    public synchronized boolean hasTransform(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        int count = this.getTransformedCount();
        for (int i = 0; i < count; ++i) {
            Transform transform = this.transformed.get(i);
            if (transform.getLoader() != loader) continue;
            return true;
        }
        return false;
    }

    public synchronized void recordCompile(String triggerClass, ClassLoader loader, boolean successful, String detail) {
        int count = this.getTransformedCount();
        for (int i = 0; i < count; ++i) {
            Transform transform = this.transformed.get(i);
            if (transform.getLoader() != loader) continue;
            transform.setCompiled(successful, detail);
        }
    }

    public synchronized void purge() {
        if (this.transformed != null) {
            int count = this.transformed.size();
            for (int i = 0; i < count; ++i) {
                Transform transform = this.transformed.get(i);
                Rule rule = transform.getRule();
                if (rule == null) continue;
                rule.purge();
            }
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        this.writeTo(writer);
        writer.flush();
        return stringWriter.toString();
    }

    public void writeTo(PrintWriter writer) {
        writer.print("# File ");
        writer.print(this.file);
        writer.print(" line ");
        writer.println(this.line);
        writer.print("RULE ");
        writer.println(this.name);
        if (this.isInterface) {
            writer.print("INTERFACE ");
        } else {
            writer.print("CLASS ");
        }
        if (this.isOverride) {
            writer.print("^");
        }
        writer.println(this.targetClass);
        writer.print("METHOD ");
        writer.println(this.targetMethod);
        if (this.imports != null) {
            for (int i = 0; i < this.imports.length; ++i) {
                writer.print("IMPORT ");
                writer.println(this.imports[i]);
            }
        }
        if (this.targetHelper != null) {
            writer.print("HELPER ");
            writer.println(this.targetHelper);
        }
        if (this.compileToBytecode) {
            writer.write("COMPILE\n");
        } else {
            writer.write("NOCOMPILE\n");
        }
        writer.println(this.targetLocation.toString());
        writer.println(this.ruleText);
        writer.println("ENDRULE");
    }
}

