/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.LocalScopeMethodVisitor;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;

public class VariableAccessCheckAdapter
extends RuleCheckAdapter {
    private String varName;
    private int flags;
    private int count;

    public VariableAccessCheckAdapter(ClassVisitor cv, TransformContext transformContext, String varName, int flags, int count) {
        super(cv, transformContext);
        this.varName = varName;
        this.flags = flags;
        this.count = count;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matchTargetMethod(access, name, desc)) {
            this.setVisited();
            return new VariableAccessCheckMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class VariableAccessCheckMethodAdapter
    extends RuleCheckMethodAdapter
    implements LocalScopeMethodVisitor {
        private int access;
        private String name;
        private String descriptor;
        private String signature;
        private String[] exceptions;
        private int index;
        private int visitedCount;

        VariableAccessCheckMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor);
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
            this.index = -1;
            this.visitedCount = 0;
        }

        private boolean matchCall(int opcode) {
            if (opcode < 54) {
                return (VariableAccessCheckAdapter.this.flags & 1) != 0;
            }
            return (VariableAccessCheckAdapter.this.flags & 2) != 0;
        }

        @Override
        public void visitLocalScopeStart(String name, String desc, String signature, int stackSlot, int startOffset) {
            if (name.equals(VariableAccessCheckAdapter.this.varName)) {
                this.index = stackSlot;
                if (startOffset > 0 && (VariableAccessCheckAdapter.this.count == 0 || this.visitedCount < VariableAccessCheckAdapter.this.count) && (VariableAccessCheckAdapter.this.flags & 2) != 0) {
                    ++this.visitedCount;
                    if (VariableAccessCheckAdapter.this.count == 0 || this.visitedCount == VariableAccessCheckAdapter.this.count) {
                        this.setTriggerPoint();
                    }
                }
            }
        }

        @Override
        public void visitLocalScopeEnd(String name, String desc, String signature, int stackSlot, int endOffset) {
            if (name.equals(VariableAccessCheckAdapter.this.varName)) {
                this.index = -1;
            }
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            if (var == this.index && (VariableAccessCheckAdapter.this.count == 0 || this.visitedCount < VariableAccessCheckAdapter.this.count) && this.matchCall(opcode)) {
                ++this.visitedCount;
                if (VariableAccessCheckAdapter.this.count == 0 || this.visitedCount == VariableAccessCheckAdapter.this.count) {
                    this.setTriggerPoint();
                }
            }
            super.visitVarInsn(opcode, var);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            if (var == this.index && (VariableAccessCheckAdapter.this.count == 0 || this.visitedCount < VariableAccessCheckAdapter.this.count)) {
                ++this.visitedCount;
                if (VariableAccessCheckAdapter.this.count == 0 || this.visitedCount == VariableAccessCheckAdapter.this.count) {
                    this.setTriggerPoint();
                }
            }
            super.visitIincInsn(var, increment);
        }
    }
}

