/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jboss.byteman.java_cup.runtime.Symbol;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.RuleElement;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.ParseException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.expression.ExpressionHelper;
import org.jboss.byteman.rule.expression.ReturnExpression;
import org.jboss.byteman.rule.expression.ThrowExpression;
import org.jboss.byteman.rule.grammar.ECAGrammarParser;
import org.jboss.byteman.rule.grammar.ECATokenLexer;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class Action
extends RuleElement {
    private List<Expression> action;

    public static Action create(Rule rule, ParseNode actionTree) throws TypeException {
        Action action = new Action(rule, actionTree);
        return action;
    }

    public static Action create(Rule rule, String text) throws ParseException, TypeException {
        if ("".equals(text)) {
            return new Action(rule);
        }
        String fullText = "BIND NOTHING IF TRUE DO \n" + text;
        try {
            ECATokenLexer lexer = new ECATokenLexer(new StringReader(text));
            ECAGrammarParser parser = new ECAGrammarParser(lexer);
            Symbol parse = parser.parse();
            ParseNode parseTree = (ParseNode)parse.value;
            ParseNode actionTree = (ParseNode)parseTree.getChild(3);
            Action action = new Action(rule, actionTree);
            return action;
        }
        catch (Exception e) {
            throw new ParseException("org.jboss.byteman.rule.Action : error parsing action\n" + text);
        }
    }

    protected Action(Rule rule, ParseNode actionTree) throws TypeException {
        super(rule);
        if (actionTree.getTag() == 12) {
            this.action = new ArrayList<Expression>();
        } else {
            this.action = ExpressionHelper.createExpressionList(rule, this.getBindings(), actionTree, Type.VOID);
            for (Expression expr : this.action) {
                expr.bind();
            }
        }
    }

    protected Action(Rule rule) {
        super(rule);
        this.action = null;
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        if (this.action != null) {
            for (Expression expr : this.action) {
                expr.typeCheck(Type.VOID);
            }
        }
        return Type.VOID;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        int currentStack = compileContext.getStackCount();
        for (Expression expr : this.action) {
            int expected;
            expr.compile(mv, compileContext);
            Type resultType = expr.getType();
            boolean maybePop = !(expr instanceof ReturnExpression) && !(expr instanceof ThrowExpression);
            if (!maybePop || resultType == Type.VOID) continue;
            int n = expected = resultType.getNBytes() > 4 ? 2 : 1;
            if (expected == 1) {
                mv.visitInsn(87);
                compileContext.addStackCount(-1);
                continue;
            }
            if (expected != 2) continue;
            mv.visitInsn(88);
            compileContext.addStackCount(-2);
        }
        if (compileContext.getStackCount() != currentStack) {
            throw new CompileException("Action.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack);
        }
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        if (this.action != null) {
            for (Expression expr : this.action) {
                expr.interpret(helper);
            }
        }
        return null;
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        if (this.action == null || this.action.size() == 0) {
            stringWriter.write("DO   NOTHING");
        } else {
            String prefix = "DO   ";
            for (Expression expr : this.action) {
                stringWriter.write(prefix);
                expr.writeTo(stringWriter);
                prefix = ";\n     ";
            }
        }
        stringWriter.write("\n");
    }
}

