/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.compiler;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.objectweb.asm.ClassWriter;
import org.jboss.byteman.objectweb.asm.FieldVisitor;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Opcodes;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;

public class Compiler
implements Opcodes {
    private static int nextId = 0;

    public static Class getHelperAdapter(Rule rule, Class helperClass, boolean compileToBytecode) throws CompileException {
        try {
            String helperName = Type.getInternalName(helperClass);
            String compiledHelperName = compileToBytecode ? helperName + "_HelperAdapter_Compiled_" + Compiler.nextId() : helperName + "_HelperAdapter_Interpreted_" + Compiler.nextId();
            byte[] classBytes = Compiler.compileBytes(rule, helperClass, helperName, compiledHelperName, compileToBytecode);
            String externalName = compiledHelperName.replace('/', '.');
            Transformer.maybeDumpClass(externalName, classBytes);
            ClassLoader loader = rule.getHelperLoader();
            return rule.getModuleSystem().loadHelperAdapter(loader, externalName, classBytes);
        }
        catch (CompileException ce) {
            throw ce;
        }
        catch (Throwable th) {
            if (compileToBytecode) {
                throw new CompileException("Compiler.createHelperAdapter : exception creating compiled helper adapter for " + helperClass.getName(), th);
            }
            throw new CompileException("Compiler.createHelperAdapter : exception creating interpreted helper adapter for " + helperClass.getName(), th);
        }
    }

    private static byte[] compileBytes(Rule rule, Class helperClass, String helperName, String compiledHelperName, boolean compileToBytecode) throws Exception {
        String name;
        Binding binding;
        boolean superWantsRule;
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, compiledHelperName, null, helperName, new String[]{"org/jboss/byteman/rule/helper/HelperAdapter"});
        String fullFileName = rule.getFile();
        int idx22 = fullFileName.lastIndexOf(File.separatorChar);
        String basicFileName = idx22 < 0 ? fullFileName : fullFileName.substring(idx22 + 1);
        String debug = "// compiled from: " + fullFileName + "\n// generated by Byteman\n";
        cw.visitSource(basicFileName, debug);
        FieldVisitor fv = cw.visitField(2, "bindingMap", "Ljava/util/HashMap;", "Ljava/util/HashMap<Ljava/lang/String;Ljava/lang/Object;>;", null);
        fv.visitEnd();
        fv = cw.visitField(2, "rule", "Lorg/jboss/byteman/rule/Rule;", "Lorg/jboss/byteman/rule/Rule;", null);
        fv.visitEnd();
        Constructor superConstructor = null;
        try {
            superConstructor = helperClass.getDeclaredConstructor(Rule.class);
        }
        catch (NoSuchMethodException idx22) {
        }
        catch (SecurityException e) {
            throw new CompileException("Compiler.compileBytes : unable to access constructor for helper class " + helperClass.getCanonicalName());
        }
        boolean bl = superWantsRule = superConstructor != null;
        if (!superWantsRule) {
            try {
                superConstructor = helperClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new CompileException("Compiler.compileBytes : no valid constructor found for helper class " + helperClass.getCanonicalName());
            }
            catch (SecurityException e) {
                throw new CompileException("Compiler.compileBytes : unable to access constructor for helper class " + helperClass.getCanonicalName());
            }
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/jboss/byteman/rule/Rule;)V", null, null);
        mv.visitCode();
        if (superWantsRule) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, helperName, "<init>", "(Lorg/jboss/byteman/rule/Rule;)V");
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, helperName, "<init>", "()V");
        }
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "java/util/HashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        mv.visitFieldInsn(181, compiledHelperName, "bindingMap", "Ljava/util/HashMap;");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "execute", "(Ljava/lang/Object;[Ljava/lang/Object;)V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
        mv.visitCode();
        mv.visitMethodInsn(184, "org/jboss/byteman/agent/Transformer", "isVerbose", "()Z");
        Label l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getName", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitLdcInsn(" execute()");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        mv.visitLabel(l0);
        Bindings bindings = rule.getBindings();
        Iterator<Binding> iterator = bindings.iterator();
        while (iterator.hasNext()) {
            binding = iterator.next();
            name = binding.getName();
            if (binding.isAlias()) continue;
            if (binding.isHelper()) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, compiledHelperName, "bindingMap", "Ljava/util/HashMap;");
                mv.visitLdcInsn(name);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                mv.visitInsn(87);
                continue;
            }
            if (binding.isRecipient()) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, compiledHelperName, "bindingMap", "Ljava/util/HashMap;");
                mv.visitLdcInsn(name);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                mv.visitInsn(87);
                continue;
            }
            if (binding.isBindVar()) continue;
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, compiledHelperName, "bindingMap", "Ljava/util/HashMap;");
            mv.visitLdcInsn(name);
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn(binding.getCallArrayIndex());
            mv.visitInsn(50);
            mv.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(87);
        }
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, compiledHelperName, "execute0", "()V");
        iterator = bindings.iterator();
        while (iterator.hasNext()) {
            binding = iterator.next();
            if (binding.isAlias()) continue;
            name = binding.getName();
            if (!binding.isUpdated() || binding.isBindVar()) continue;
            int idx = binding.getCallArrayIndex();
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn(idx);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, compiledHelperName, "bindingMap", "Ljava/util/HashMap;");
            mv.visitLdcInsn(name);
            mv.visitMethodInsn(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            mv.visitInsn(83);
        }
        mv.visitInsn(177);
        mv.visitMaxs(4, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setBinding", "(Ljava/lang/String;Ljava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "bindingMap", "Ljava/util/HashMap;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getBinding", "(Ljava/lang/String;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "bindingMap", "Ljava/util/HashMap;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getName", "()Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getAccessibleField", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getAccessibleField", "(Ljava/lang/Object;I)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setAccessibleField", "(Ljava/lang/Object;Ljava/lang/Object;I)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(21, 3);
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "setAccessibleField", "(Ljava/lang/Object;Ljava/lang/Object;I)V");
        mv.visitInsn(177);
        mv.visitMaxs(4, 4);
        mv.visitEnd();
        mv = cw.visitMethod(1, "invokeAccessibleMethod", "(Ljava/lang/Object;[Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(21, 3);
        mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "invokeAccessibleMethod", "(Ljava/lang/Object;[Ljava/lang/Object;I)Ljava/lang/Object;");
        mv.visitInsn(176);
        mv.visitMaxs(4, 4);
        mv.visitEnd();
        if (compileToBytecode) {
            mv = cw.visitMethod(2, "execute0", "()V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            CompileContext compileContext = new CompileContext(mv);
            compileContext.notifySourceLine(rule.getLine());
            compileContext.addLocalCount(3);
            rule.getEvent().compile(mv, compileContext);
            rule.getCondition().compile(mv, compileContext);
            Label l02 = new Label();
            mv.visitJumpInsn(153, l02);
            compileContext.addStackCount(-1);
            rule.getAction().compile(mv, compileContext);
            mv.visitLabel(l02);
            compileContext.notifySourceEnd();
            mv.visitInsn(177);
            mv.visitMaxs(compileContext.getStackMax(), compileContext.getLocalMax());
            mv.visitEnd();
        } else {
            mv = cw.visitMethod(2, "execute0", "()V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, compiledHelperName, "bind", "()V");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, compiledHelperName, "test", "()Z");
            l0 = new Label();
            mv.visitJumpInsn(153, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, compiledHelperName, "fire", "()V");
            mv.visitLabel(l0);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            mv = cw.visitMethod(2, "bind", "()V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getEvent", "()Lorg/jboss/byteman/rule/Event;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Event", "interpret", "(Lorg/jboss/byteman/rule/helper/HelperAdapter;)Ljava/lang/Object;");
            mv.visitInsn(177);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
            mv = cw.visitMethod(2, "test", "()Z", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getCondition", "()Lorg/jboss/byteman/rule/Condition;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Condition", "interpret", "(Lorg/jboss/byteman/rule/helper/HelperAdapter;)Ljava/lang/Object;");
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
            mv.visitInsn(172);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
            mv = cw.visitMethod(2, "fire", "()V", null, new String[]{"org/jboss/byteman/rule/exception/ExecuteException"});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, compiledHelperName, "rule", "Lorg/jboss/byteman/rule/Rule;");
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Rule", "getAction", "()Lorg/jboss/byteman/rule/Action;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/jboss/byteman/rule/Action", "interpret", "(Lorg/jboss/byteman/rule/helper/HelperAdapter;)Ljava/lang/Object;");
            mv.visitInsn(177);
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static synchronized int nextId() {
        return ++nextId;
    }
}

