/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.AuthenticationMechanism;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchSchemaFactory;
import org.apache.calcite.adapter.mongodb.MongoSchemaFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.jeecg.modules.jmreport.calcite.adapter.files.JmFilesSchema;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.config.oss.JmReportUploadConfig;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;

public class JmSchemaFactory {
    private static final Pattern PATTERN_MONGODB_URL = Pattern.compile("^(?<url>[^/]+)/(?<database>[^?]+)(?:\\\\?(?:.*&)?authSource=(?<authSource>[^&]+))?$");
    private final JmReportUploadConfig jmReportUploadConfig;
    private static final Map<String, Schema> SCHEMA_CACHE = new ConcurrentHashMap<String, Schema>();

    public JmSchemaFactory(JmReportUploadConfig jmReportUploadConfig) {
        this.jmReportUploadConfig = jmReportUploadConfig;
    }

    public void create(SchemaPlus rootSchema, String schemaName, JmreportDynamicDataSourceVo config) {
        try {
            switch (config.getDbType()) {
                case "FILES": {
                    this.createFileSchema(rootSchema, config);
                    break;
                }
                case "mongodb": {
                    this.createMongoSchema(rootSchema, config);
                    break;
                }
                case "es": {
                    this.createEsSchema(rootSchema, config);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data source type: " + config.getDbType());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse DataSourceConfig from operand: " + config.getDbName(), e);
        }
    }

    private void createEsSchema(SchemaPlus rootSchema, JmreportDynamicDataSourceVo dbSource) {
        Schema schema = this.getSchemaFromCache(dbSource);
        if (OkConvertUtils.isEmpty((Object)schema)) {
            JSONArray hosts = new JSONArray();
            hosts.add((Object)dbSource.getDbUrl());
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("hosts", JSONObject.toJSONString((Object)hosts));
            config.put("pathPrefix", "");
            config.put("username", dbSource.getDbUsername());
            config.put("password", dbSource.getDbPassword());
            schema = new ElasticsearchSchemaFactory().create(rootSchema, "esSchema", config);
            this.setSchemaCache(dbSource, schema);
        }
        if (OkConvertUtils.isEmpty((Object)schema)) {
            throw new JimuReportException("Elasticsearch\u8fde\u63a5\u6784\u9020\u5931\u8d25");
        }
        rootSchema.add("es", schema);
    }

    private void createFileSchema(SchemaPlus rootSchema, JmreportDynamicDataSourceVo operand) {
        String directory = operand.getDbDriver();
        File directoryFile = new File(directory);
        if (!directoryFile.isAbsolute()) {
            File base = new File(this.jmReportUploadConfig.getPath().getUpload());
            directoryFile = new File(base, directory);
        }
        JmFilesSchema csvSchema = new JmFilesSchema(directoryFile, operand);
        rootSchema.add("jmf", (Schema)csvSchema);
    }

    public void createMongoSchema(SchemaPlus rootSchema, JmreportDynamicDataSourceVo dbSource) {
        Schema mongoSchema = this.getSchemaFromCache(dbSource);
        if (OkConvertUtils.isEmpty((Object)mongoSchema)) {
            String mongoDbUrl = dbSource.getDbUrl();
            Matcher matcher = PATTERN_MONGODB_URL.matcher(mongoDbUrl);
            if (matcher.find()) {
                String url = "mongodb://" + matcher.group("url");
                String database = matcher.group("database");
                String authSource = matcher.group("authSource");
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("host", url);
                config.put("database", database);
                config.put("authMechanism", AuthenticationMechanism.SCRAM_SHA_256.getMechanismName());
                config.put("username", dbSource.getDbUsername());
                config.put("password", dbSource.getDbPassword());
                config.put("authDatabase", OkConvertUtils.getString((String)authSource, (String)"admin"));
                mongoSchema = new MongoSchemaFactory().create(rootSchema, "mongoSchema", config);
                this.setSchemaCache(dbSource, mongoSchema);
            } else {
                throw new JimuReportException("mongoDB\u8fde\u63a5\u5730\u5740\u9519\u8bef");
            }
        }
        if (OkConvertUtils.isEmpty((Object)mongoSchema)) {
            throw new JimuReportException("mongoDB\u8fde\u63a5\u6784\u9020\u5931\u8d25");
        }
        rootSchema.add("mongo", mongoSchema);
    }

    private Schema getSchemaFromCache(JmreportDynamicDataSourceVo dbSource) {
        if (OkConvertUtils.isEmpty((Object)dbSource)) {
            return null;
        }
        String key = JSONObject.toJSONString((Object)dbSource);
        return SCHEMA_CACHE.get(key);
    }

    private void setSchemaCache(JmreportDynamicDataSourceVo dbSource, Schema schema) {
        if (OkConvertUtils.isEmpty((Object)dbSource)) {
            return;
        }
        String key = JSONObject.toJSONString((Object)dbSource);
        SCHEMA_CACHE.put(key, schema);
    }
}

