/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.calcite.adapter.files;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jeecg.modules.jmreport.calcite.adapter.JmCalciteDataConverter;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmExcelEnumerator
implements Enumerator<Object[]> {
    private static final Logger log = LoggerFactory.getLogger(JmExcelEnumerator.class);
    private final Enumerator<@Nullable Object[]> enumerator;

    public JmExcelEnumerator(List<? extends @Nullable Object> list) {
        ArrayList<@Nullable Object[]> objs = new ArrayList<Object[]>();
        for (Object object : list) {
            if (object instanceof Collection) {
                List tmp = (List)object;
                objs.add(tmp.toArray());
                continue;
            }
            if (object instanceof Map) {
                objs.add(((LinkedHashMap)object).values().toArray());
                continue;
            }
            objs.add(new Object[]{object});
        }
        this.enumerator = Linq4j.enumerator(objs);
    }

    static JmCalciteDataConverter deduceRowType(RelDataTypeFactory typeFactory, Sheet sheet) {
        ArrayList<Object> list = new ArrayList<Object>();
        TreeMap typeMaps = new TreeMap();
        TreeMap<Integer, String> headerMaps = new TreeMap<Integer, String>();
        if (OkConvertUtils.isNotEmpty((Object)sheet)) {
            for (Row row : sheet) {
                int rowNumber = row.getRowNum();
                if (0 == rowNumber) {
                    for (Cell cell : row) {
                        int columnIndex = cell.getColumnIndex();
                        String headerValue = cell.getStringCellValue();
                        headerMaps.put(columnIndex, headerValue);
                    }
                    continue;
                }
                LinkedHashMap dataMap = new LinkedHashMap();
                headerMaps.forEach((cellIx, headerName) -> {
                    Cell cell = row.getCell(cellIx.intValue());
                    if (null == cell) {
                        dataMap.put(headerName, JmExcelEnumerator.getDefaultNonValue((RelDataType)typeMaps.get(cellIx)));
                    } else {
                        Object dataValue = JmExcelEnumerator.getCellValue(cell, (RelDataType)typeMaps.get(cellIx));
                        dataMap.put(headerName, dataValue);
                        if (OkConvertUtils.isNotEmpty((Object)dataValue)) {
                            RelDataType type = typeFactory.createJavaType(dataValue.getClass());
                            typeMaps.put(cellIx, type);
                            if (!list.isEmpty()) {
                                list.forEach(listDataMap -> {
                                    Map beforeDataMap = (Map)listDataMap;
                                    Object data = beforeDataMap.get(headerName);
                                    data = OkConvertUtils.isEmpty(data) ? JmExcelEnumerator.getDefaultNonValue(type) : JmExcelEnumerator.convertNum2TrueType(data, type);
                                    beforeDataMap.put(headerName, data);
                                });
                            }
                        }
                    }
                });
                list.add(dataMap);
            }
        } else {
            throw new JimuReportException("deduceRelType error: Sheet is null");
        }
        RelDataType stringDataType = typeFactory.createJavaType(String.class);
        headerMaps.keySet().forEach(ix -> {
            if (!typeMaps.containsKey(ix)) {
                typeMaps.put(ix, stringDataType);
            }
        });
        List zip = Pair.zip(new ArrayList(headerMaps.values()), new ArrayList(typeMaps.values()));
        RelDataType relDataType = typeFactory.createStructType(zip);
        return new JmCalciteDataConverter(relDataType, list);
    }

    private static Object getDefaultNonValue(RelDataType type) {
        Object data = "";
        if (OkConvertUtils.isEmpty((Object)type)) {
            return data;
        }
        String typeString = type.getFullTypeString().toLowerCase();
        if (typeString.contains("double")) {
            data = 0.0;
        } else if (typeString.contains("integer")) {
            data = 0;
        } else if (typeString.contains("long")) {
            data = 0L;
        } else if (typeString.contains("string")) {
            data = "";
        } else if (typeString.contains("date")) {
            data = null;
        }
        return data;
    }

    private static Object getCellValue(Cell cell, RelDataType relDataType) {
        Object dataValue = "";
        if (cell.getCellType() != CellType.BLANK) {
            block0 : switch (cell.getCellType()) {
                case STRING: {
                    dataValue = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        dataValue = cell.getDateCellValue();
                        break;
                    }
                    dataValue = cell.getNumericCellValue();
                    break;
                }
                case BOOLEAN: {
                    dataValue = cell.getBooleanCellValue();
                    break;
                }
                case FORMULA: {
                    switch (cell.getCachedFormulaResultType()) {
                        case NUMERIC: {
                            dataValue = cell.getNumericCellValue();
                            break block0;
                        }
                        case STRING: {
                            dataValue = cell.getStringCellValue();
                            break block0;
                        }
                        case BOOLEAN: {
                            dataValue = cell.getBooleanCellValue();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        if (OkConvertUtils.isNotEmpty((Object)dataValue)) {
            if (dataValue instanceof String) {
                if (null != relDataType) {
                    String typeString = relDataType.getFullTypeString().toLowerCase();
                    if (typeString.contains("double") || typeString.contains("integer") || typeString.contains("long")) {
                        dataValue = JmExcelEnumerator.convertNum2TrueType(dataValue, relDataType);
                    } else if (typeString.contains("date")) {
                        dataValue = Boolean.parseBoolean((String)dataValue);
                    }
                }
            } else if (dataValue instanceof Double) {
                dataValue = JmExcelEnumerator.convertNum2TrueType(dataValue, relDataType);
            }
        } else {
            dataValue = JmExcelEnumerator.getDefaultNonValue(relDataType);
        }
        return dataValue;
    }

    public static Object convertNum2TrueType(Object originVal, RelDataType targetType) {
        Double doubleVal;
        if (originVal == null) {
            return null;
        }
        Object convertedValue = originVal;
        if (convertedValue instanceof String) {
            try {
                convertedValue = Double.parseDouble((String)originVal);
            }
            catch (NumberFormatException e) {
                return originVal;
            }
        }
        if (convertedValue instanceof Double && !Double.isNaN(doubleVal = (Double)convertedValue) && !Double.isInfinite(doubleVal) && doubleVal % 1.0 == 0.0) {
            long longValue = doubleVal.longValue();
            convertedValue = longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE ? (Number)doubleVal.intValue() : (Number)longValue;
        }
        if (targetType != null) {
            SqlTypeName typeName = targetType.getSqlTypeName();
            if (typeName == SqlTypeName.INTEGER && convertedValue instanceof Integer) {
                return ((Number)convertedValue).intValue();
            }
            if (typeName == SqlTypeName.BIGINT && convertedValue instanceof Number) {
                return ((Number)convertedValue).longValue();
            }
            if (typeName == SqlTypeName.DOUBLE && convertedValue instanceof Number) {
                return ((Number)convertedValue).doubleValue();
            }
            if (typeName == SqlTypeName.DECIMAL && convertedValue instanceof Number) {
                return BigDecimal.valueOf(((Number)convertedValue).doubleValue());
            }
        }
        return convertedValue;
    }

    public Object[] current() {
        return (Object[])this.enumerator.current();
    }

    public boolean moveNext() {
        return this.enumerator.moveNext();
    }

    public void reset() {
        this.enumerator.reset();
    }

    public void close() {
        this.enumerator.close();
    }
}

