/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.cache.manager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jeecgframework.poi.cache.manager.FileLoade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class POICacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(POICacheManager.class);
    private static LoadingCache<String, byte[]> loadingCache = CacheBuilder.newBuilder().expireAfterWrite(7L, TimeUnit.DAYS).maximumSize(50L).build((CacheLoader)new CacheLoader<String, byte[]>(){

        public byte[] load(String url) throws Exception {
            return new FileLoade().getFile(url);
        }
    });

    public static InputStream getFile(String id) {
        try {
            byte[] result = Arrays.copyOf((byte[])loadingCache.get((Object)id), ((byte[])loadingCache.get((Object)id)).length);
            return new ByteArrayInputStream(result);
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static void cleanAll() {
        loadingCache.invalidateAll();
    }

    public static void clean(String id) {
        loadingCache.invalidate((Object)id);
    }
}

