/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.wxstore.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.jeewx.api.core.common.JSONHelper;
import org.jeewx.api.core.common.WxstoreUtils;
import org.jeewx.api.wxstore.order.model.OrderDelivery;
import org.jeewx.api.wxstore.order.model.OrderInfo;
import org.jeewx.api.wxstore.order.model.OrderPara;
import org.jeewx.api.wxstore.order.model.OrderRtnInfo;

public class JwOrderManagerAPI {
    private static String getid_order_url = "https://api.weixin.qq.com/merchant/order/getbyid?access_token=ACCESS_TOKEN";
    private static String getfilter_order_url = "https://api.weixin.qq.com/merchant/order/getbyfilter?access_token=ACCESS_TOKEN";
    private static String setdelivery_order_url = "https://api.weixin.qq.com/merchant/order/setdelivery?access_token=ACCESS_TOKEN";
    private static String close_order_url = "https://api.weixin.qq.com/merchant/order/close?access_token=ACCESS_TOKEN";

    public static OrderInfo getByOrderId(String newAccessToken, String order_id) {
        if (newAccessToken != null) {
            String requestUrl = getid_order_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"order_id\": \"" + order_id + "\"}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", json);
            OrderInfo orderInfo = null;
            JSONObject info = result.getJSONObject("order");
            orderInfo = (OrderInfo)JSONObject.toJavaObject((JSON)info, OrderInfo.class);
            return orderInfo;
        }
        return null;
    }

    public static List<OrderInfo> getByFilter(String newAccessToken, OrderPara orderPara) {
        if (newAccessToken != null) {
            String requestUrl = getfilter_order_url.replace("ACCESS_TOKEN", newAccessToken);
            JSONObject obj = JSONObject.parseObject((String)JSON.toJSONString((Object)orderPara));
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "GET", obj.toString());
            List<OrderInfo> orderInfos = null;
            JSONArray info = result.getJSONArray("order_list");
            orderInfos = JSONHelper.toList(info, OrderInfo.class);
            return orderInfos;
        }
        return null;
    }

    public static OrderRtnInfo doDelivery(String newAccessToken, OrderDelivery orderDelivery) {
        if (newAccessToken != null) {
            String requestUrl = setdelivery_order_url.replace("ACCESS_TOKEN", newAccessToken);
            JSONObject obj = JSONObject.parseObject((String)JSON.toJSONString((Object)orderDelivery));
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", obj.toString());
            OrderRtnInfo orderRtnInfo = (OrderRtnInfo)JSONObject.toJavaObject((JSON)result, OrderRtnInfo.class);
            return orderRtnInfo;
        }
        return null;
    }

    public static OrderRtnInfo doCloseOrder(String newAccessToken, String order_id) {
        if (newAccessToken != null) {
            String requestUrl = close_order_url.replace("ACCESS_TOKEN", newAccessToken);
            String json = "{\"order_id\": \"" + order_id + "\"}";
            JSONObject result = WxstoreUtils.httpRequest(requestUrl, "POST", json);
            OrderRtnInfo orderRtnInfo = (OrderRtnInfo)JSONObject.toJavaObject((JSON)result, OrderRtnInfo.class);
            return orderRtnInfo;
        }
        return null;
    }
}

