/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.DummyAccessorInvocationTransformer;
import org.jetbrains.kotlin.js.inline.ExpressionDecomposer;
import org.jetbrains.kotlin.js.inline.FunctionInlineMutator;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.InlineableResult;
import org.jetbrains.kotlin.js.inline.clean.FunctionPostProcessor;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedFunctionDefinitionsKt;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedImportsKt;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedLocalFunctionDeclarationsKt;
import org.jetbrains.kotlin.js.inline.clean.SimplifyWrappedFunctionsKt;
import org.jetbrains.kotlin.js.inline.context.FunctionContext;
import org.jetbrains.kotlin.js.inline.context.InliningContext;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.NamingUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;
import org.jetbrains.kotlin.js.translate.declaration.InlineCoroutineUtilKt;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class JsInliner
extends JsVisitorWithContextImpl {
    private final JsConfig config;
    private final Map<JsName, FunctionWithWrapper> functions;
    private final Map<String, FunctionWithWrapper> accessors;
    private final Stack<JsInliningContext> inliningContexts = new Stack();
    private final Set<JsFunction> processedFunctions = CollectionUtilsKt.IdentitySet();
    private final Set<JsFunction> inProcessFunctions = CollectionUtilsKt.IdentitySet();
    private final FunctionReader functionReader;
    private final DiagnosticSink trace;
    private Map<String, JsName> existingImports = new HashMap<String, JsName>();
    private JsContext<JsStatement> statementContextForInline;
    private final Map<JsBlock, FunctionWithWrapper> functionsByWrapperNodes = new HashMap<JsBlock, FunctionWithWrapper>();
    private final Map<JsFunction, FunctionWithWrapper> functionsByFunctionNodes = new HashMap<JsFunction, FunctionWithWrapper>();
    private final Stack<JsFunction> namedFunctionsStack = new Stack();
    private final LinkedList<JsCallInfo> inlineCallInfos = new LinkedList();
    private final Function1<JsNode, Boolean> canBeExtractedByInliner = node -> node instanceof JsInvocation && this.hasToBeInlined((JsInvocation)node);
    private int inlineFunctionDepth;
    private final Map<JsWrapperKey, Map<JsName, JsExpression>> replacementsInducedByWrappers = new HashMap<JsWrapperKey, Map<JsName, JsExpression>>();

    public static void process(@NotNull JsConfig.Reporter reporter, @NotNull JsConfig config, @NotNull DiagnosticSink trace, @NotNull JsName currentModuleName, @NotNull List<JsProgramFragment> fragments2, @NotNull List<JsProgramFragment> fragmentsToProcess, @NotNull List<JsStatement> importStatements) {
        Map<JsName, FunctionWithWrapper> functions2 = CollectUtilsKt.collectNamedFunctionsAndWrappers(fragments2);
        Map<String, FunctionWithWrapper> accessors = CollectUtilsKt.collectAccessors(fragments2);
        DummyAccessorInvocationTransformer accessorInvocationTransformer = new DummyAccessorInvocationTransformer();
        for (JsProgramFragment fragment : fragmentsToProcess) {
            accessorInvocationTransformer.accept(fragment.getDeclarationBlock());
            accessorInvocationTransformer.accept(fragment.getInitializerBlock());
        }
        FunctionReader functionReader = new FunctionReader(reporter, config, currentModuleName, fragments2);
        JsInliner inliner = new JsInliner(config, functions2, accessors, functionReader, trace);
        for (JsStatement statement2 : importStatements) {
            inliner.processImportStatement(statement2);
        }
        for (JsProgramFragment fragment : fragmentsToProcess) {
            inliner.existingImports.clear();
            Stack<JsInliningContext> stack = inliner.inliningContexts;
            JsInliner jsInliner = inliner;
            jsInliner.getClass();
            stack.push(jsInliner.new JsInliningContext(inliner.new JsVisitorWithContextImpl.ListContext<JsStatement>()));
            inliner.acceptStatement(fragment.getDeclarationBlock());
            JsFunction fakeInitFunction = new JsFunction((JsScope)JsDynamicScope.INSTANCE, fragment.getInitializerBlock(), "");
            JsGlobalBlock initWrapper = new JsGlobalBlock();
            initWrapper.getStatements().add(new JsExpressionStatement(fakeInitFunction));
            inliner.accept(initWrapper);
            initWrapper.getStatements().remove(initWrapper.getStatements().size() - 1);
            inliner.inliningContexts.pop();
            fragment.getInitializerBlock().getStatements().addAll(0, initWrapper.getStatements());
        }
        for (JsProgramFragment fragment : fragmentsToProcess) {
            JsBlock block = new JsBlock(fragment.getDeclarationBlock(), fragment.getInitializerBlock(), fragment.getExportBlock());
            RemoveUnusedImportsKt.removeUnusedImports(block);
            SimplifyWrappedFunctionsKt.simplifyWrappedFunctions(block);
            RemoveUnusedFunctionDefinitionsKt.removeUnusedFunctionDefinitions(block, CollectUtilsKt.collectNamedFunctions(block));
        }
    }

    private JsInliner(@NotNull JsConfig config, @NotNull Map<JsName, FunctionWithWrapper> functions2, @NotNull Map<String, FunctionWithWrapper> accessors, @NotNull FunctionReader functionReader, @NotNull DiagnosticSink trace) {
        this.config = config;
        this.functions = functions2;
        this.accessors = accessors;
        this.functionReader = functionReader;
        this.trace = trace;
        Stream.concat(functions2.values().stream(), accessors.values().stream()).forEach(f -> {
            this.functionsByFunctionNodes.put(f.getFunction(), (FunctionWithWrapper)f);
            if (f.getWrapperBody() != null) {
                this.functionsByWrapperNodes.put(f.getWrapperBody(), (FunctionWithWrapper)f);
            }
        });
    }

    private void processImportStatement(JsStatement statement2) {
        JsVars jsVars;
        String tag;
        if (statement2 instanceof JsVars && (tag = CollectUtilsKt.getImportTag(jsVars = (JsVars)statement2)) != null) {
            this.existingImports.put(tag, jsVars.getVars().get(0).getName());
        }
    }

    @Override
    public boolean visit(@NotNull JsFunction function2, @NotNull JsContext context) {
        FunctionWithWrapper functionWithWrapper = this.functionsByFunctionNodes.get(function2);
        if (functionWithWrapper != null) {
            this.visit(functionWithWrapper);
            return false;
        }
        this.startFunction(function2);
        return super.visit(function2, context);
    }

    @Override
    public void endVisit(@NotNull JsFunction function2, @NotNull JsContext context) {
        super.endVisit(function2, context);
        if (!this.functionsByFunctionNodes.containsKey(function2)) {
            this.endFunction(function2);
        }
    }

    private void startFunction(@NotNull JsFunction function2) {
        JsContext<JsStatement> statementContext = this.statementContextForInline != null ? this.statementContextForInline : this.getLastStatementLevelContext();
        this.inliningContexts.push(new JsInliningContext(statementContext));
        assert (!this.inProcessFunctions.contains(function2)) : "Inliner has revisited function";
        this.inProcessFunctions.add(function2);
        if (this.functions.values().stream().anyMatch(namedFunction -> namedFunction.getFunction().equals(function2))) {
            this.namedFunctionsStack.push(function2);
        }
    }

    private void endFunction(@NotNull JsFunction function2) {
        NamingUtilsKt.refreshLabelNames(function2.getBody(), function2.getScope());
        RemoveUnusedLocalFunctionDeclarationsKt.removeUnusedLocalFunctionDeclarations(function2);
        this.processedFunctions.add(function2);
        new FunctionPostProcessor(function2).apply();
        assert (this.inProcessFunctions.contains(function2));
        this.inProcessFunctions.remove(function2);
        this.inliningContexts.pop();
        if (!this.namedFunctionsStack.empty() && this.namedFunctionsStack.peek() == function2) {
            this.namedFunctionsStack.pop();
        }
    }

    @Override
    public boolean visit(@NotNull JsBlock x, @NotNull JsContext ctx) {
        FunctionWithWrapper functionWithWrapper = this.functionsByWrapperNodes.get(x);
        if (functionWithWrapper != null) {
            this.visit(functionWithWrapper);
            return false;
        }
        return super.visit(x, ctx);
    }

    private void visit(@NotNull FunctionWithWrapper functionWithWrapper) {
        JsContext<JsStatement> oldContextForInline = this.statementContextForInline;
        Map<String, JsName> oldExistingImports = this.existingImports;
        JsVisitorWithContextImpl.ListContext<JsStatement> innerContext = new JsVisitorWithContextImpl.ListContext<JsStatement>();
        JsBlock wrapperBody = functionWithWrapper.getWrapperBody();
        List<JsStatement> statements = null;
        if (wrapperBody != null) {
            this.existingImports = new HashMap<String, JsName>();
            this.statementContexts.push(innerContext);
            this.statementContextForInline = innerContext;
            for (JsStatement statement2 : wrapperBody.getStatements()) {
                this.processImportStatement(statement2);
            }
            assert (functionWithWrapper.getWrapperBody() != null);
            statements = functionWithWrapper.getWrapperBody().getStatements();
            if (!statements.isEmpty() && statements.get(statements.size() - 1) instanceof JsReturn) {
                statements = statements.subList(0, statements.size() - 1);
            }
            innerContext.traverse(statements);
            this.statementContexts.pop();
        } else {
            this.statementContextForInline = this.getLastStatementLevelContext();
        }
        this.startFunction(functionWithWrapper.getFunction());
        JsBlock block = new JsBlock((JsStatement)functionWithWrapper.getFunction().getBody());
        innerContext.traverse(block.getStatements());
        functionWithWrapper.getFunction().getBody().traverse(this, innerContext);
        this.endFunction(functionWithWrapper.getFunction());
        if (statements != null) {
            statements.addAll(block.getStatements().subList(0, block.getStatements().size() - 1));
        }
        this.statementContextForInline = oldContextForInline;
        this.existingImports = oldExistingImports;
    }

    @Override
    public boolean visit(@NotNull JsInvocation call2, @NotNull JsContext context) {
        FunctionWithWrapper definition;
        if (InlineMetadata.decompose(call2) != null) {
            ++this.inlineFunctionDepth;
        }
        if (!this.hasToBeInlined(call2)) {
            return true;
        }
        JsFunction containingFunction = this.getCurrentNamedFunction();
        if (containingFunction != null) {
            this.inlineCallInfos.add(new JsCallInfo(call2, containingFunction));
        }
        if (this.inProcessFunctions.contains((definition = this.getFunctionContext().getFunctionDefinition(call2)).getFunction())) {
            this.reportInlineCycle(call2, definition.getFunction());
        } else if (!this.processedFunctions.contains(definition.getFunction())) {
            for (int i = 0; i < call2.getArguments().size(); ++i) {
                JsExpression argument = call2.getArguments().get(i);
                call2.getArguments().set(i, this.accept(argument));
            }
            ++this.inlineFunctionDepth;
            this.visit(definition);
            --this.inlineFunctionDepth;
            return false;
        }
        return true;
    }

    @Override
    public void endVisit(@NotNull JsInvocation x, @NotNull JsContext ctx) {
        if (InlineMetadata.decompose(x) != null) {
            --this.inlineFunctionDepth;
        }
        if (this.hasToBeInlined(x)) {
            this.inline(x, ctx);
        }
        JsCallInfo lastCallInfo = null;
        if (!this.inlineCallInfos.isEmpty()) {
            lastCallInfo = this.inlineCallInfos.getLast();
        }
        if (lastCallInfo != null && lastCallInfo.call == x) {
            this.inlineCallInfos.removeLast();
        }
    }

    @Override
    protected void doAcceptStatementList(List<JsStatement> statements) {
        if (!this.inliningContexts.isEmpty()) {
            List<JsStatement> additionalStatements;
            for (int i = 0; i < statements.size(); i += additionalStatements.size() + 1) {
                additionalStatements = ExpressionDecomposer.preserveEvaluationOrder(statements.get(i), this.canBeExtractedByInliner);
                statements.addAll(i, additionalStatements);
            }
        }
        super.doAcceptStatementList(statements);
    }

    private void inline(@NotNull JsInvocation call2, @NotNull JsContext context) {
        JsName returnVariable;
        CallableDescriptor callDescriptor = MetadataProperties.getDescriptor(call2);
        if (JsInliner.isSuspendWithCurrentContinuation(callDescriptor)) {
            this.inlineSuspendWithCurrentContinuation(call2, context);
            return;
        }
        JsInliningContext inliningContext = this.getInliningContext();
        FunctionWithWrapper functionWithWrapper = inliningContext.getFunctionContext().getFunctionDefinition(call2);
        if (this.functionsByFunctionNodes.containsKey(functionWithWrapper.getFunction())) {
            functionWithWrapper = this.functionsByFunctionNodes.get(functionWithWrapper.getFunction());
        }
        JsFunction function2 = functionWithWrapper.getFunction().deepCopy();
        function2.setBody(InlineCoroutineUtilKt.transformSpecialFunctionsToCoroutineMetadata(function2.getBody()));
        if (functionWithWrapper.getWrapperBody() != null) {
            this.applyWrapper(functionWithWrapper.getWrapperBody(), function2, functionWithWrapper.getFunction(), inliningContext);
        }
        InlineableResult inlineableResult = FunctionInlineMutator.getInlineableCallReplacement(call2, function2, inliningContext);
        JsStatement inlineableBody = inlineableResult.getInlineableBody();
        JsExpression resultExpression = inlineableResult.getResultExpression();
        JsContext<JsStatement> statementContext = inliningContext.getStatementContext();
        JsStatement inlineableBodyWithLambdasInlined = this.accept(inlineableBody);
        assert (inlineableBody == inlineableBodyWithLambdasInlined);
        JsFunction currentFunction = this.getCurrentNamedFunction();
        if (currentFunction != null && (returnVariable = MetadataProperties.getForcedReturnVariable(currentFunction)) != null) {
            inlineableBody.accept(new RecursiveJsVisitor(){

                @Override
                public void visitReturn(@NotNull JsReturn x) {
                    x.setExpression(returnVariable.makeRef());
                }
            });
        }
        statementContext.addPrevious(JsAstUtils.flattenStatement(inlineableBody));
        if (resultExpression == null) {
            statementContext.removeMe();
            return;
        }
        resultExpression = this.accept(resultExpression);
        MetadataProperties.setSynthetic(resultExpression, true);
        context.replaceMe(resultExpression);
    }

    private void applyWrapper(@NotNull JsBlock wrapper, @NotNull JsFunction function2, @NotNull JsFunction originalFunction, @NotNull InliningContext inliningContext) {
        Function<JsWrapperKey, Map> replacementGen = k -> {
            JsContext ctx = k.context;
            HashMap<JsName, JsNameRef> newReplacements = new HashMap<JsName, JsNameRef>();
            ArrayList<JsStatement> copiedStatements = new ArrayList<JsStatement>();
            for (JsStatement statement2 : wrapper.getStatements()) {
                JsVars jsVars;
                String tag;
                if (statement2 instanceof JsReturn) continue;
                statement2 = statement2.deepCopy();
                if (this.inlineFunctionDepth == 0) {
                    JsInliner.replaceExpressionsWithLocalAliases(statement2);
                }
                if (statement2 instanceof JsVars && (tag = CollectUtilsKt.getImportTag(jsVars = (JsVars)statement2)) != null) {
                    JsName existingName;
                    JsName name2 = jsVars.getVars().get(0).getName();
                    JsName jsName = existingName = this.inlineFunctionDepth == 0 ? MetadataProperties.getLocalAlias(name2) : null;
                    if (existingName == null) {
                        existingName = this.existingImports.computeIfAbsent(tag, t -> {
                            copiedStatements.add(jsVars);
                            JsName alias = JsScope.declareTemporaryName(name2.getIdent());
                            alias.copyMetadataFrom(name2);
                            newReplacements.put(name2, JsAstUtils.pureFqn(alias, null));
                            return alias;
                        });
                    }
                    if (name2 == existingName) continue;
                    JsNameRef replacement = JsAstUtils.pureFqn(existingName, null);
                    newReplacements.put(name2, replacement);
                    continue;
                }
                copiedStatements.add(statement2);
            }
            Set definedNames = copiedStatements.stream().flatMap(node -> CollectUtilsKt.collectDefinedNamesInAllScopes(node).stream()).filter(name -> !newReplacements.containsKey(name)).collect(Collectors.toSet());
            for (JsName jsName : definedNames) {
                JsName alias = JsScope.declareTemporaryName(jsName.getIdent());
                alias.copyMetadataFrom(jsName);
                JsNameRef replacement = JsAstUtils.pureFqn(alias, null);
                newReplacements.put(jsName, replacement);
            }
            for (JsStatement jsStatement : copiedStatements) {
                JsStatement jsStatement2 = RewriteUtilsKt.replaceNames(jsStatement, newReplacements);
                ctx.addPrevious(this.accept(jsStatement2));
            }
            for (Map.Entry entry : CollectUtilsKt.collectNamedFunctions(new JsBlock(copiedStatements)).entrySet()) {
                if (!(MetadataProperties.getStaticRef((JsName)entry.getKey()) instanceof JsFunction)) continue;
                MetadataProperties.setStaticRef((JsName)entry.getKey(), (JsNode)entry.getValue());
            }
            return newReplacements;
        };
        JsWrapperKey key = new JsWrapperKey(inliningContext.getStatementContextBeforeCurrentFunction(), originalFunction);
        Map replacements = this.replacementsInducedByWrappers.computeIfAbsent(key, replacementGen);
        RewriteUtilsKt.replaceNames(function2, replacements);
    }

    private static void replaceExpressionsWithLocalAliases(@NotNull JsStatement statement2) {
        new JsVisitorWithContextImpl(){

            @Override
            public void endVisit(@NotNull JsNameRef x, @NotNull JsContext ctx) {
                this.replaceIfNecessary(x, ctx);
            }

            @Override
            public void endVisit(@NotNull JsArrayAccess x, @NotNull JsContext ctx) {
                this.replaceIfNecessary(x, ctx);
            }

            private void replaceIfNecessary(@NotNull JsExpression expression2, @NotNull JsContext context) {
                JsName alias = MetadataProperties.getLocalAlias(expression2);
                if (alias != null) {
                    context.replaceMe(alias.makeRef());
                }
            }
        }.accept(statement2);
    }

    private static boolean isSuspendWithCurrentContinuation(@Nullable DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        return CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineOrReturn((FunctionDescriptor)descriptor2.getOriginal());
    }

    private void inlineSuspendWithCurrentContinuation(@NotNull JsInvocation call2, @NotNull JsContext context) {
        JsExpression lambda2 = call2.getArguments().get(0);
        JsExpression continuationArg = call2.getArguments().get(call2.getArguments().size() - 1);
        JsInvocation invocation = new JsInvocation(lambda2, continuationArg);
        MetadataProperties.setSuspend(invocation, true);
        context.replaceMe(this.accept(invocation));
    }

    @NotNull
    private JsInliningContext getInliningContext() {
        return this.inliningContexts.peek();
    }

    @NotNull
    private FunctionContext getFunctionContext() {
        return this.getInliningContext().getFunctionContext();
    }

    @Nullable
    private JsFunction getCurrentNamedFunction() {
        if (this.namedFunctionsStack.empty()) {
            return null;
        }
        return this.namedFunctionsStack.peek();
    }

    private void reportInlineCycle(@NotNull JsInvocation call2, @NotNull JsFunction calledFunction) {
        MetadataProperties.setInlineStrategy(call2, InlineStrategy.NOT_INLINE);
        Iterator<JsCallInfo> it = this.inlineCallInfos.descendingIterator();
        while (it.hasNext()) {
            JsCallInfo callInfo = it.next();
            PsiElement psiElement = MetadataProperties.getPsiElement(callInfo.call);
            CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(callInfo.call);
            if (psiElement != null && descriptor2 != null) {
                this.trace.report(Errors.INLINE_CALL_CYCLE.on(psiElement, descriptor2));
            }
            if (callInfo.containingFunction != calledFunction) continue;
            break;
        }
    }

    private boolean hasToBeInlined(@NotNull JsInvocation call2) {
        InlineStrategy strategy = MetadataProperties.getInlineStrategy(call2);
        if (strategy == null || !strategy.isInline()) {
            return false;
        }
        return this.getFunctionContext().hasFunctionDefinition(call2);
    }

    static class JsWrapperKey {
        final JsContext context;
        private final JsFunction function;

        public JsWrapperKey(@NotNull JsContext context, @NotNull JsFunction function2) {
            this.context = context;
            this.function = function2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsWrapperKey key = (JsWrapperKey)o;
            return Objects.equals(this.context, key.context) && Objects.equals(this.function, key.function);
        }

        public int hashCode() {
            return Objects.hash(this.context, this.function);
        }
    }

    private static class JsCallInfo {
        @NotNull
        public final JsInvocation call;
        @NotNull
        public final JsFunction containingFunction;

        private JsCallInfo(@NotNull JsInvocation call2, @NotNull JsFunction function2) {
            this.call = call2;
            this.containingFunction = function2;
        }
    }

    private class JsInliningContext
    implements InliningContext {
        private final FunctionContext functionContext;
        @NotNull
        private final JsContext<JsStatement> statementContextBeforeCurrentFunction;

        JsInliningContext(@NotNull JsContext<JsStatement> statementContextBeforeCurrentFunction) {
            this.functionContext = new FunctionContext(JsInliner.this.functionReader, JsInliner.this.config){

                @Override
                @Nullable
                protected FunctionWithWrapper lookUpStaticFunction(@Nullable JsName functionName) {
                    return (FunctionWithWrapper)JsInliner.this.functions.get(functionName);
                }

                @Override
                @Nullable
                protected FunctionWithWrapper lookUpStaticFunctionByTag(@NotNull String functionTag) {
                    return (FunctionWithWrapper)JsInliner.this.accessors.get(functionTag);
                }
            };
            this.statementContextBeforeCurrentFunction = statementContextBeforeCurrentFunction;
        }

        @Override
        @NotNull
        public NamingContext newNamingContext() {
            return new NamingContext(this.getStatementContext());
        }

        @Override
        @NotNull
        public JsContext<JsStatement> getStatementContext() {
            return JsInliner.this.getLastStatementLevelContext();
        }

        @Override
        @NotNull
        public FunctionContext getFunctionContext() {
            return this.functionContext;
        }

        @Override
        @NotNull
        public JsContext<JsStatement> getStatementContextBeforeCurrentFunction() {
            return this.statementContextBeforeCurrentFunction;
        }
    }
}

