/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class FunctionDescriptorUtil {
    private static final TypeSubstitutor MAKE_TYPE_PARAMETERS_FRESH = TypeSubstitutor.create(new TypeSubstitution(){

        @Override
        public TypeProjection get(@NotNull KotlinType key) {
            return null;
        }

        public String toString() {
            return "FunctionDescriptorUtil.MAKE_TYPE_PARAMETERS_FRESH";
        }
    });

    private FunctionDescriptorUtil() {
    }

    public static TypeSubstitution createSubstitution(@NotNull FunctionDescriptor functionDescriptor, @NotNull List<KotlinType> typeArguments2) {
        if (functionDescriptor.getTypeParameters().isEmpty()) {
            return TypeSubstitution.EMPTY;
        }
        return new IndexedParametersSubstitution(functionDescriptor.getTypeParameters(), TypeUtilsKt.defaultProjections(typeArguments2));
    }

    @NotNull
    public static LexicalScope getFunctionInnerScope(@NotNull LexicalScope outerScope, @NotNull FunctionDescriptor descriptor2, @NotNull BindingTrace trace, @NotNull OverloadChecker overloadChecker) {
        return FunctionDescriptorUtil.getFunctionInnerScope(outerScope, descriptor2, new TraceBasedLocalRedeclarationChecker(trace, overloadChecker));
    }

    @NotNull
    public static LexicalScope getFunctionInnerScope(@NotNull LexicalScope outerScope, @NotNull FunctionDescriptor descriptor2, @NotNull LocalRedeclarationChecker redeclarationChecker) {
        return new LexicalScopeImpl(outerScope, descriptor2, true, descriptor2.getExtensionReceiverParameter(), LexicalScopeKind.FUNCTION_INNER_SCOPE, redeclarationChecker, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)((Function1)handler2 -> {
            for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
                handler2.addClassifierDescriptor(typeParameter);
            }
            for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getValueParameters()) {
                if (valueParameterDescriptor instanceof ValueParameterDescriptorImpl.WithDestructuringDeclaration) {
                    List<VariableDescriptor> entries = ((ValueParameterDescriptorImpl.WithDestructuringDeclaration)valueParameterDescriptor).getDestructuringVariables();
                    for (VariableDescriptor entry : entries) {
                        handler2.addVariableDescriptor(entry);
                    }
                    continue;
                }
                handler2.addVariableDescriptor(valueParameterDescriptor);
            }
            return Unit.INSTANCE;
        }));
    }

    public static <D extends CallableDescriptor> D alphaConvertTypeParameters(D candidate) {
        return (D)((CallableDescriptor)candidate.substitute(MAKE_TYPE_PARAMETERS_FRESH));
    }
}

