/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.rule.engine.cluster.worker;

import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.rule.engine.api.RuleConstants;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.Output;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class QueueEventOutput
implements Output {
    private final String instanceId;
    private final ClusterManager clusterManager;
    private final String event;
    private final String sourceNode;

    public Mono<Boolean> write(Publisher<RuleData> dataStream) {
        return this.clusterManager.getQueue(this.createTopic(this.sourceNode)).add(dataStream);
    }

    public Mono<Void> write(String nodeId, Publisher<RuleData> data) {
        return this.clusterManager.getQueue(this.createTopic(nodeId)).add(data).then();
    }

    private String createTopic(String node) {
        return RuleConstants.Topics.input((String)this.instanceId, (String)node);
    }

    public QueueEventOutput(String instanceId, ClusterManager clusterManager, String event, String sourceNode) {
        this.instanceId = instanceId;
        this.clusterManager = clusterManager;
        this.event = event;
        this.sourceNode = sourceNode;
    }

    public String getEvent() {
        return this.event;
    }
}

