/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSDeltaConsumer;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class FSCommitEditor
implements ISVNEditor {
    private Map myPathsToLockTokens;
    private Collection myLockTokens;
    private String myAuthor;
    private String myBasePath;
    private String myLogMessage;
    private FSTransactionInfo myTxn;
    private FSTransactionRoot myTxnRoot;
    private boolean isTxnOwner;
    private FSFS myFSFS;
    private FSRepository myRepository;
    private Stack myDirsStack;
    private FSDeltaConsumer myDeltaConsumer;
    private Map myCurrentFileProps;
    private String myCurrentFilePath;
    private FSCommitter myCommitter;

    public FSCommitEditor(String path, String logMessage, String userName, Map lockTokens, boolean keepLocks, FSTransactionInfo txn, FSFS owner, FSRepository repository) {
        this.myPathsToLockTokens = !keepLocks ? lockTokens : null;
        this.myLockTokens = lockTokens != null ? lockTokens.values() : new LinkedList();
        this.myAuthor = userName;
        this.myBasePath = path;
        this.myLogMessage = logMessage;
        this.myTxn = txn;
        this.isTxnOwner = txn == null;
        this.myRepository = repository;
        this.myFSFS = owner;
        this.myDirsStack = new Stack();
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void openRoot(long revision) throws SVNException {
        long youngestRev = this.myFSFS.getYoungestRevision();
        if (this.isTxnOwner) {
            this.myTxn = this.beginTransactionForCommit(youngestRev);
        } else {
            if (this.myAuthor != null && !"".equals(this.myAuthor)) {
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:author", this.myAuthor);
            }
            if (this.myLogMessage != null && !"".equals(this.myLogMessage)) {
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:log", this.myLogMessage);
            }
        }
        this.myTxnRoot = this.myFSFS.createTransactionRoot(this.myTxn.getTxnId());
        this.myCommitter = new FSCommitter(this.myFSFS, this.myTxnRoot, this.myTxn, this.myLockTokens, this.myAuthor);
        DirBaton dirBaton = new DirBaton(revision, this.myBasePath, false);
        this.myDirsStack.push(dirBaton);
    }

    private FSTransactionInfo beginTransactionForCommit(long baseRevision) throws SVNException {
        FSHooks.runStartCommitHook(this.myFSFS.getRepositoryRoot(), this.myAuthor);
        FSTransactionInfo txn = FSTransactionRoot.beginTransaction(baseRevision, 2, this.myFSFS);
        if (this.myAuthor != null && !"".equals(this.myAuthor)) {
            this.myFSFS.setTransactionProperty(txn.getTxnId(), "svn:author", this.myAuthor);
        }
        if (this.myLogMessage != null && !"".equals(this.myLogMessage)) {
            this.myFSFS.setTransactionProperty(txn.getTxnId(), "svn:log", this.myLogMessage);
        }
        return txn;
    }

    public void openDir(String path, long revision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        String fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path);
        SVNNodeKind kind = this.myTxnRoot.checkNodeKind(fullPath);
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Path ''{0}'' not present", path);
            SVNErrorManager.error(err);
        }
        DirBaton dirBaton = new DirBaton(revision, fullPath, parentBaton.isCopied());
        this.myDirsStack.push(dirBaton);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        String fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path);
        SVNNodeKind kind = this.myTxnRoot.checkNodeKind(fullPath);
        if (kind == SVNNodeKind.NONE) {
            return;
        }
        FSRevisionNode existingNode = this.myTxnRoot.getRevisionNode(fullPath);
        long createdRev = existingNode.getId().getRevision();
        if (FSRepository.isValidRevision(revision) && revision < createdRev) {
            SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, this.myTxnRoot.getTxnID()));
        }
        this.myCommitter.deleteNode(fullPath);
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        String fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path);
        boolean isCopied = false;
        if (copyFromPath != null && FSRepository.isInvalidRevision(copyFromRevision)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Got source path but no source revision for ''{0}''", fullPath);
            SVNErrorManager.error(err);
        } else if (copyFromPath != null) {
            SVNNodeKind kind = this.myTxnRoot.checkNodeKind(fullPath);
            if (kind != SVNNodeKind.NONE && !parentBaton.isCopied()) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, this.myTxnRoot.getTxnID()));
            }
            copyFromPath = this.myRepository.getRepositoryPath(copyFromPath);
            FSRevisionRoot copyRoot = this.myFSFS.createRevisionRoot(copyFromRevision);
            this.myCommitter.makeCopy(copyRoot, copyFromPath, fullPath, true);
            isCopied = true;
        } else {
            this.myCommitter.makeDir(fullPath);
        }
        DirBaton dirBaton = new DirBaton(-1L, fullPath, isCopied);
        this.myDirsStack.push(dirBaton);
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        DirBaton dirBaton = (DirBaton)this.myDirsStack.peek();
        if (FSRepository.isValidRevision(dirBaton.getBaseRevision())) {
            FSRevisionNode existingNode = this.myTxnRoot.getRevisionNode(dirBaton.getPath());
            long createdRev = existingNode.getId().getRevision();
            if (dirBaton.getBaseRevision() < createdRev) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(dirBaton.getPath(), this.myTxnRoot.getTxnID()));
            }
        }
        this.myCommitter.changeNodeProperty(dirBaton.getPath(), name, value);
    }

    private void changeNodeProperties(String path, Map propNamesToValues) throws SVNException {
        FSParentPath parentPath = null;
        Map properties = null;
        boolean done = false;
        boolean haveRealChanges = false;
        for (String propName : propNamesToValues.keySet()) {
            if (!SVNProperty.isRegularProperty(propName)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Storage of non-regular property ''{0}'' is disallowed through the repository interface, and could indicate a bug in your client", propName);
                SVNErrorManager.error(err);
            }
            if (!done) {
                parentPath = this.myTxnRoot.openPath(path, true, true);
                if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
                    FSCommitter.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, false, false);
                }
                this.myCommitter.makePathMutable(parentPath, path);
                properties = parentPath.getRevNode().getProperties(this.myFSFS);
                done = true;
            }
            String propValue = (String)propNamesToValues.get(propName);
            if (properties.isEmpty() && propValue == null) continue;
            if (propValue == null) {
                properties.remove(propName);
            } else {
                properties.put(propName, propValue);
            }
            if (haveRealChanges) continue;
            haveRealChanges = true;
        }
        if (haveRealChanges) {
            this.myTxnRoot.setProplist(parentPath.getRevNode(), properties);
            this.myCommitter.addChange(path, parentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, false, true, -1L, null);
        }
    }

    public void closeDir() throws SVNException {
        this.flushPendingProperties();
        this.myDirsStack.pop();
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = (DirBaton)this.myDirsStack.peek();
        String fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path);
        if (copyFromPath != null && FSRepository.isInvalidRevision(copyFromRevision)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Got source path but no source revision for ''{0}''", fullPath);
            SVNErrorManager.error(err);
        } else if (copyFromPath != null) {
            SVNNodeKind kind = this.myTxnRoot.checkNodeKind(fullPath);
            if (kind != SVNNodeKind.NONE && !parentBaton.isCopied()) {
                SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, this.myTxnRoot.getTxnID()));
            }
            copyFromPath = this.myRepository.getRepositoryPath(copyFromPath);
            FSRevisionRoot copyRoot = this.myFSFS.createRevisionRoot(copyFromRevision);
            this.myCommitter.makeCopy(copyRoot, copyFromPath, fullPath, true);
        } else {
            this.myCommitter.makeFile(fullPath);
        }
    }

    public void openFile(String path, long revision) throws SVNException {
        String fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path);
        FSRevisionNode revNode = this.myTxnRoot.getRevisionNode(fullPath);
        if (FSRepository.isValidRevision(revision) && revision < revNode.getId().getRevision()) {
            SVNErrorManager.error(FSErrors.errorOutOfDate(fullPath, this.myTxnRoot.getTxnID()));
        }
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.flushPendingProperties();
        FSDeltaConsumer fsfsConsumer = this.getDeltaConsumer();
        fsfsConsumer.applyTextDelta(path, baseChecksum);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        FSDeltaConsumer fsfsConsumer = this.getDeltaConsumer();
        return fsfsConsumer.textDeltaChunk(path, diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        FSDeltaConsumer fsfsConsumer = this.getDeltaConsumer();
        fsfsConsumer.textDeltaEnd(path);
    }

    private FSDeltaConsumer getDeltaConsumer() {
        if (this.myDeltaConsumer == null) {
            this.myDeltaConsumer = new FSDeltaConsumer(this.myBasePath, this.myTxnRoot, this.myFSFS, this.myCommitter, this.myAuthor, this.myLockTokens);
        }
        return this.myDeltaConsumer;
    }

    public void changeFileProperty(String path, String name, String value) throws SVNException {
        String fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path);
        Map props = this.getFilePropertiesStorage();
        if (!fullPath.equals(this.myCurrentFilePath)) {
            if (this.myCurrentFilePath != null) {
                this.changeNodeProperties(this.myCurrentFilePath, props);
                props.clear();
            }
            this.myCurrentFilePath = fullPath;
        }
        props.put(name, value);
    }

    private Map getFilePropertiesStorage() {
        if (this.myCurrentFileProps == null) {
            this.myCurrentFileProps = new HashMap();
        }
        return this.myCurrentFileProps;
    }

    private void flushPendingProperties() throws SVNException {
        if (this.myCurrentFilePath != null) {
            Map props = this.getFilePropertiesStorage();
            this.changeNodeProperties(this.myCurrentFilePath, props);
            props.clear();
            this.myCurrentFilePath = null;
        }
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        String fullPath;
        FSRevisionNode revNode;
        this.flushPendingProperties();
        if (textChecksum != null && (revNode = this.myTxnRoot.getRevisionNode(fullPath = SVNPathUtil.concatToAbs(this.myBasePath, path))).getTextRepresentation() != null && !textChecksum.equals(revNode.getTextRepresentation().getHexDigest())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for resulting fulltext\n({0}):\n   expected checksum:  {1}\n   actual checksum:    {2}\n", new Object[]{fullPath, textChecksum, revNode.getTextRepresentation().getHexDigest()});
            SVNErrorManager.error(err);
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myTxn == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "No valid transaction supplied to closeEdit()");
            SVNErrorManager.error(err);
        }
        long committedRev = -1L;
        SVNErrorMessage errorMessage = null;
        committedRev = this.finalizeCommit();
        try {
            FSHooks.runPostCommitHook(this.myFSFS.getRepositoryRoot(), committedRev);
        }
        catch (SVNException svne) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, svne.getErrorMessage().getFullMessage(), 1);
        }
        Map revProps = this.myFSFS.getRevisionProperties(committedRev);
        String dateProp = (String)revProps.get("svn:date");
        String authorProp = (String)revProps.get("svn:author");
        Date datestamp = dateProp != null ? SVNTimeUtil.parseDateString(dateProp) : null;
        SVNCommitInfo info = new SVNCommitInfo(committedRev, authorProp, datestamp, errorMessage);
        this.releaseLocks();
        this.myRepository.closeRepository();
        return info;
    }

    private void releaseLocks() throws SVNException {
        if (this.myPathsToLockTokens != null) {
            for (String path : this.myPathsToLockTokens.keySet()) {
                String token = (String)this.myPathsToLockTokens.get(path);
                String absPath = !path.startsWith("/") ? SVNPathUtil.concatToAbs(this.myBasePath, path) : path;
                try {
                    this.myFSFS.unlockPath(absPath, token, this.myAuthor, false, true);
                }
                catch (SVNException svne) {}
            }
        }
    }

    private long finalizeCommit() throws SVNException {
        FSHooks.runPreCommitHook(this.myFSFS.getRepositoryRoot(), this.myTxn.getTxnId());
        return this.myCommitter.commitTxn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortEdit() throws SVNException {
        if (this.myDeltaConsumer != null) {
            this.myDeltaConsumer.abort();
        }
        if (this.myTxn == null || !this.isTxnOwner) {
            this.myRepository.closeRepository();
            return;
        }
        try {
            FSCommitter.abortTransaction(this.myFSFS, this.myTxn.getTxnId());
        }
        finally {
            this.myRepository.closeRepository();
        }
        this.myTxn = null;
        this.myTxnRoot = null;
    }

    private static class DirBaton {
        private long myBaseRevision;
        private String myPath;
        private boolean isCopied;

        public DirBaton(long revision, String path, boolean copied) {
            this.myBaseRevision = revision;
            this.myPath = path;
            this.isCopied = copied;
        }

        public boolean isCopied() {
            return this.isCopied;
        }

        public void setCopied(boolean isCopied) {
            this.isCopied = isCopied;
        }

        public long getBaseRevision() {
            return this.myBaseRevision;
        }

        public void setBaseRevision(long baseRevision) {
            this.myBaseRevision = baseRevision;
        }

        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }
    }
}

