/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.delta.SVNVDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.delta.SVNXDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class SVNDeltaGenerator {
    private SVNDeltaAlgorithm myXDelta = new SVNXDeltaAlgorithm();
    private SVNDeltaAlgorithm myVDelta = new SVNVDeltaAlgorithm();
    private byte[] mySourceBuffer;
    private byte[] myTargetBuffer;

    public SVNDeltaGenerator() {
        this(102400);
    }

    public SVNDeltaGenerator(int maximumDiffWindowSize) {
        this.mySourceBuffer = new byte[maximumDiffWindowSize];
        this.myTargetBuffer = new byte[maximumDiffWindowSize];
    }

    public String sendDelta(String path, InputStream target, ISVNDeltaConsumer consumer, boolean computeChecksum) throws SVNException {
        return this.sendDelta(path, SVNFileUtil.DUMMY_IN, 0L, target, consumer, computeChecksum);
    }

    public String sendDelta(String path, InputStream source, long sourceOffset, InputStream target, ISVNDeltaConsumer consumer, boolean computeChecksum) throws SVNException {
        MessageDigest digest = null;
        if (computeChecksum) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
                return null;
            }
        }
        boolean windowSent = false;
        while (true) {
            int sourceLength;
            int targetLength;
            try {
                targetLength = target.read(this.myTargetBuffer, 0, this.myTargetBuffer.length);
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
                return null;
            }
            if (targetLength <= 0) {
                if (windowSent || consumer == null) break;
                consumer.textDeltaChunk(path, SVNDiffWindow.EMPTY);
                break;
            }
            try {
                sourceLength = source.read(this.mySourceBuffer, 0, this.mySourceBuffer.length);
            }
            catch (IOException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                SVNErrorManager.error(err, e);
                return null;
            }
            if (sourceLength < 0) {
                sourceLength = 0;
            }
            if (digest != null) {
                digest.update(this.myTargetBuffer, 0, targetLength);
            }
            this.sendDelta(path, sourceOffset, this.mySourceBuffer, sourceLength, this.myTargetBuffer, targetLength, consumer);
            windowSent = true;
            sourceOffset += (long)sourceLength;
        }
        if (consumer != null) {
            consumer.textDeltaEnd(path);
        }
        return SVNFileUtil.toHexDigest(digest);
    }

    public void sendDelta(String path, byte[] target, int targetLength, ISVNDeltaConsumer consumer) throws SVNException {
        this.sendDelta(path, null, 0, 0L, target, targetLength, consumer);
    }

    public void sendDelta(String path, byte[] source, int sourceLength, long sourceOffset, byte[] target, int targetLength, ISVNDeltaConsumer consumer) throws SVNException {
        if (targetLength == 0 || target == null) {
            if (consumer != null) {
                consumer.textDeltaChunk(path, SVNDiffWindow.EMPTY);
            }
            return;
        }
        if (source == null) {
            source = new byte[]{};
            sourceLength = 0;
        } else if (sourceLength < 0) {
            sourceLength = 0;
        }
        this.sendDelta(path, sourceOffset, source == null ? new byte[]{} : source, sourceLength, target, targetLength, consumer);
    }

    private void sendDelta(String path, long sourceOffset, byte[] source, int sourceLength, byte[] target, int targetLength, ISVNDeltaConsumer consumer) throws SVNException {
        SVNDeltaAlgorithm algorithm = sourceLength == 0 ? this.myVDelta : this.myXDelta;
        algorithm.computeDelta(source, sourceLength, target, targetLength);
        if (consumer == null) {
            algorithm.reset();
            return;
        }
        int instructionsLength = algorithm.getInstructionsLength();
        int newDataLength = algorithm.getNewDataLength();
        SVNDiffWindow window = new SVNDiffWindow(sourceOffset, sourceLength, targetLength, instructionsLength, newDataLength);
        window.setData(algorithm.getData());
        OutputStream os = consumer.textDeltaChunk(path, window);
        SVNFileUtil.closeFile(os);
        algorithm.reset();
    }
}

