/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.kie.dmn.api.core.DMNContext;

public class DMNContextImpl
implements DMNContext {
    private static final String DEFAULT_IDENT = "    ";
    private Map<String, Object> entries = new LinkedHashMap<String, Object>();

    public DMNContextImpl() {
    }

    public DMNContextImpl(Map<String, Object> entries) {
        this.entries = entries;
    }

    public Object set(String name, Object value) {
        return this.entries.put(name, value);
    }

    public Object get(String name) {
        return this.entries.get(name);
    }

    public Map<String, Object> getAll() {
        return this.entries;
    }

    public boolean isDefined(String name) {
        return this.entries.containsKey(name);
    }

    public DMNContext clone() {
        return new DMNContextImpl(new LinkedHashMap<String, Object>(this.entries));
    }

    public String toString() {
        return this.printContext(this.entries, "");
    }

    private String printContext(Map<String, Object> context, String ident) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        for (Map.Entry<String, Object> e : context.entrySet()) {
            builder.append(ident).append(DEFAULT_IDENT).append((Object)e.getKey()).append(": ");
            if (e.getValue() instanceof Map) {
                builder.append(this.printContext((Map)e.getValue(), ident + DEFAULT_IDENT));
                continue;
            }
            builder.append(e.getValue()).append("\n");
        }
        builder.append(ident + "}\n");
        return builder.toString();
    }
}

