/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.core.ast.ItemDefNode;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.marshalling.v1_1.DMNExtensionRegister;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.util.DefaultDMNMessagesManager;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Definitions;

public class DMNModelImpl
implements DMNModel,
DMNMessageManager,
Externalizable {
    private SerializationFormat serializedAs = SerializationFormat.DMN_XML;
    private Resource resource;
    private Definitions definitions;
    private Map<String, InputDataNode> inputs = new HashMap<String, InputDataNode>();
    private Map<String, DecisionNode> decisions = new HashMap<String, DecisionNode>();
    private Map<String, BusinessKnowledgeModelNode> bkms = new HashMap<String, BusinessKnowledgeModelNode>();
    private Map<String, ItemDefNode> itemDefs = new HashMap<String, ItemDefNode>();
    private DMNMessageManager messages = new DefaultDMNMessagesManager();
    private DMNTypeRegistry types = new DMNTypeRegistry();
    private boolean runtimeTypeCheck = false;

    public DMNModelImpl() {
    }

    public DMNModelImpl(Definitions definitions) {
        this.definitions = definitions;
    }

    public DMNTypeRegistry getTypeRegistry() {
        return this.types;
    }

    public String getNamespace() {
        return this.definitions != null ? this.definitions.getNamespace() : null;
    }

    public String getName() {
        return this.definitions != null ? this.definitions.getName() : null;
    }

    public Definitions getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Definitions definitions) {
        this.definitions = definitions;
    }

    public void addInput(InputDataNode idn) {
        this.inputs.put(idn.getId(), idn);
    }

    public InputDataNode getInputById(String id) {
        return this.inputs.get(id);
    }

    public InputDataNode getInputByName(String name) {
        if (name == null) {
            return null;
        }
        for (InputDataNode in : this.inputs.values()) {
            if (in.getName() == null || !name.equals(in.getName())) continue;
            return in;
        }
        return null;
    }

    public Set<InputDataNode> getInputs() {
        return this.inputs.values().stream().collect(Collectors.toSet());
    }

    public void addDecision(DecisionNode dn) {
        this.decisions.put(dn.getId(), dn);
    }

    public DecisionNode getDecisionById(String id) {
        return this.decisions.get(id);
    }

    public DecisionNode getDecisionByName(String name) {
        if (name == null) {
            return null;
        }
        for (DecisionNode dn : this.decisions.values()) {
            if (dn.getName() == null || !name.equals(dn.getName())) continue;
            return dn;
        }
        return null;
    }

    public Set<DecisionNode> getDecisions() {
        return this.decisions.values().stream().collect(Collectors.toSet());
    }

    public Set<InputDataNode> getRequiredInputsForDecisionName(String decisionName) {
        DecisionNodeImpl decision = (DecisionNodeImpl)this.getDecisionByName(decisionName);
        HashSet<InputDataNode> inputs = new HashSet<InputDataNode>();
        if (decision != null) {
            this.collectRequiredInputs(decision.getDependencies().values(), inputs);
        }
        return inputs;
    }

    public Set<InputDataNode> getRequiredInputsForDecisionId(String decisionId) {
        DecisionNodeImpl decision = (DecisionNodeImpl)this.getDecisionById(decisionId);
        HashSet<InputDataNode> inputs = new HashSet<InputDataNode>();
        if (decision != null) {
            this.collectRequiredInputs(decision.getDependencies().values(), inputs);
        }
        return inputs;
    }

    public void addBusinessKnowledgeModel(BusinessKnowledgeModelNode bkm) {
        this.bkms.put(bkm.getId(), bkm);
    }

    public BusinessKnowledgeModelNode getBusinessKnowledgeModelById(String id) {
        return this.bkms.get(id);
    }

    public BusinessKnowledgeModelNode getBusinessKnowledgeModelByName(String name) {
        if (name == null) {
            return null;
        }
        for (BusinessKnowledgeModelNode bkm : this.bkms.values()) {
            if (bkm.getName() == null || !name.equals(bkm.getName())) continue;
            return bkm;
        }
        return null;
    }

    public Set<BusinessKnowledgeModelNode> getBusinessKnowledgeModels() {
        return this.bkms.values().stream().collect(Collectors.toSet());
    }

    private void collectRequiredInputs(Collection<DMNNode> deps, Set<InputDataNode> inputs) {
        deps.forEach(dep -> {
            if (dep instanceof InputDataNode) {
                inputs.add((InputDataNode)dep);
            } else if (dep instanceof DecisionNode) {
                this.collectRequiredInputs(((DecisionNodeImpl)dep).getDependencies().values(), inputs);
            } else if (dep instanceof BusinessKnowledgeModelNode) {
                this.collectRequiredInputs(((BusinessKnowledgeModelNodeImpl)dep).getDependencies().values(), inputs);
            }
        });
    }

    public void addItemDefinition(ItemDefNode idn) {
        this.itemDefs.put(idn.getId() != null ? idn.getId() : "_" + this.itemDefs.size(), idn);
    }

    public ItemDefNode getItemDefinitionById(String id) {
        return this.itemDefs.get(id);
    }

    public ItemDefNode getItemDefinitionByName(String name) {
        if (name == null) {
            return null;
        }
        for (ItemDefNode in : this.itemDefs.values()) {
            if (in.getName() == null || !name.equals(in.getName())) continue;
            return in;
        }
        return null;
    }

    public Set<ItemDefNode> getItemDefinitions() {
        return this.itemDefs.values().stream().collect(Collectors.toSet());
    }

    public List<DMNMessage> getMessages() {
        return this.messages.getMessages();
    }

    public List<DMNMessage> getMessages(DMNMessage.Severity ... sevs) {
        return this.messages.getMessages(sevs);
    }

    public boolean hasErrors() {
        return this.messages.hasErrors();
    }

    @Override
    public void addAll(List<DMNMessage> messages) {
        this.messages.addAll(messages);
    }

    @Override
    public DMNMessage addMessage(DMNMessage msg) {
        return this.messages.addMessage(msg);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source) {
        return this.messages.addMessage(severity, message, messageType, source);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, Throwable exception) {
        return this.messages.addMessage(severity, message, messageType, source, exception);
    }

    @Override
    public DMNMessage addMessage(DMNMessage.Severity severity, String message, DMNMessageType messageType, DMNModelInstrumentedBase source, FEELEvent feelEvent) {
        return this.messages.addMessage(severity, message, messageType, source, feelEvent);
    }

    public boolean removeDMNNodeFromIndexes(DMNNode node) {
        if (node instanceof DecisionNode) {
            return this.decisions.entrySet().removeIf(kv -> ((DecisionNode)kv.getValue()).equals(node));
        }
        if (node instanceof BusinessKnowledgeModelNode) {
            return this.bkms.entrySet().removeIf(kv -> ((BusinessKnowledgeModelNode)kv.getValue()).equals(node));
        }
        if (node instanceof InputDataNode) {
            return this.inputs.entrySet().removeIf(kv -> ((InputDataNode)kv.getValue()).equals(node));
        }
        return false;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isRuntimeTypeCheck() {
        return this.runtimeTypeCheck;
    }

    public void setRuntimeTypeCheck(boolean runtimeTypeCheck) {
        this.runtimeTypeCheck = runtimeTypeCheck;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.serializedAs);
        out.writeObject(this.resource);
        if (!(out instanceof DroolsObjectOutputStream)) {
            throw new UnsupportedOperationException();
        }
        DroolsObjectOutputStream os = (DroolsObjectOutputStream)out;
        DMNCompilerImpl compiler = (DMNCompilerImpl)os.getCustomExtensions().get("DMN_COMPILER_CACHE_KEY");
        List<DMNExtensionRegister> dmnRegisteredExtensions = compiler.getRegisteredExtensions();
        String output = DMNMarshallerFactory.newMarshallerWithExtensions(dmnRegisteredExtensions).marshal((Object)this.definitions);
        out.writeObject(output);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Definitions definitions;
        this.serializedAs = (SerializationFormat)((Object)in.readObject());
        this.resource = (Resource)in.readObject();
        String xml = (String)in.readObject();
        if (!(in instanceof DroolsObjectInputStream)) {
            throw new UnsupportedOperationException();
        }
        DroolsObjectInputStream is = (DroolsObjectInputStream)in;
        DMNCompilerImpl compiler = (DMNCompilerImpl)is.getCustomExtensions().get("DMN_COMPILER_CACHE_KEY");
        List<DMNExtensionRegister> dmnRegisteredExtensions = compiler.getRegisteredExtensions();
        this.definitions = definitions = DMNMarshallerFactory.newMarshallerWithExtensions(dmnRegisteredExtensions).unmarshal(xml);
        DMNModelImpl compiledModel = (DMNModelImpl)compiler.compile(definitions);
        this.inputs = compiledModel.inputs;
        this.decisions = compiledModel.decisions;
        this.bkms = compiledModel.bkms;
        this.itemDefs = compiledModel.itemDefs;
        this.messages = compiledModel.messages;
        this.types = compiledModel.types;
        this.runtimeTypeCheck = compiledModel.runtimeTypeCheck;
    }

    private static enum SerializationFormat {
        DMN_XML;

    }
}

