/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.List;
import java.util.function.Consumer;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.impl.AfterEvaluateBKMEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateDecisionEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateDecisionTableEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateBKMEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateDecisionEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateDecisionTableEventImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DMNRuntimeEventManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger(DMNRuntimeEventManagerUtils.class);

    public static void fireBeforeEvaluateDecision(DMNRuntimeEventManager eventManager, DecisionNode decision, DMNResult result) {
        BeforeEvaluateDecisionEventImpl event = new BeforeEvaluateDecisionEventImpl(decision, result);
        DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateDecision(event));
    }

    public static void fireAfterEvaluateDecision(DMNRuntimeEventManager eventManager, DecisionNode decision, DMNResult result) {
        AfterEvaluateDecisionEventImpl event = new AfterEvaluateDecisionEventImpl(decision, result);
        DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateDecision(event));
    }

    public static void fireBeforeEvaluateBKM(DMNRuntimeEventManager eventManager, BusinessKnowledgeModelNode bkm, DMNResult result) {
        BeforeEvaluateBKMEventImpl event = new BeforeEvaluateBKMEventImpl(bkm, result);
        DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateBKM(event));
    }

    public static void fireAfterEvaluateBKM(DMNRuntimeEventManager eventManager, BusinessKnowledgeModelNode bkm, DMNResult result) {
        AfterEvaluateBKMEventImpl event = new AfterEvaluateBKMEventImpl(bkm, result);
        DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateBKM(event));
    }

    public static void fireBeforeEvaluateDecisionTable(DMNRuntimeEventManager eventManager, String nodeName, String dtName, DMNResult result) {
        BeforeEvaluateDecisionTableEventImpl event = new BeforeEvaluateDecisionTableEventImpl(nodeName, dtName, result);
        DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateDecisionTable(event));
    }

    public static void fireAfterEvaluateDecisionTable(DMNRuntimeEventManager eventManager, String nodeName, String dtName, DMNResult result, List<Integer> matches, List<Integer> fired) {
        AfterEvaluateDecisionTableEventImpl event = new AfterEvaluateDecisionTableEventImpl(nodeName, dtName, result, matches, fired);
        DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateDecisionTable(event));
    }

    private static void notifyListeners(DMNRuntimeEventManager eventManager, Consumer<DMNRuntimeEventListener> consumer) {
        for (DMNRuntimeEventListener listener : eventManager.getListeners()) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable t) {
                logger.error("Error notifying listener '" + listener + "'", t);
            }
        }
    }

    private DMNRuntimeEventManagerUtils() {
    }
}

