/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieRuntime;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNPackage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.ast.InputDataNodeImpl;
import org.kie.dmn.core.compiler.DMNOption;
import org.kie.dmn.core.compiler.DMNProfile;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.DMNDecisionResultImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.impl.DMNPackageImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerUtils;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNRuntimeImpl
implements DMNRuntime {
    private static final Logger logger = LoggerFactory.getLogger(DMNRuntimeImpl.class);
    private KieRuntime runtime;
    private DMNRuntimeEventManagerImpl eventManager;
    private boolean overrideRuntimeTypeCheck = false;

    public DMNRuntimeImpl(KieRuntime runtime) {
        this.runtime = runtime;
        this.eventManager = new DMNRuntimeEventManagerImpl();
    }

    public List<DMNModel> getModels() {
        ArrayList<DMNModel> models = new ArrayList<DMNModel>();
        this.runtime.getKieBase().getKiePackages().forEach(kpkg -> {
            DMNPackage dmnPkg = (DMNPackage)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.DMN);
            if (dmnPkg != null) {
                dmnPkg.getAllModels().values().forEach(model -> models.add((DMNModel)model));
            }
        });
        return models;
    }

    public DMNModel getModel(String namespace, String modelName) {
        InternalKnowledgePackage kpkg = (InternalKnowledgePackage)this.runtime.getKieBase().getKiePackage(namespace);
        if (kpkg == null) {
            return null;
        }
        Map map = kpkg.getResourceTypePackages();
        DMNPackage dmnpkg = (DMNPackage)map.get(ResourceType.DMN);
        return dmnpkg != null ? dmnpkg.getModel(modelName) : null;
    }

    public DMNResult evaluateAll(DMNModel model, DMNContext context) {
        boolean performRuntimeTypeCheck = this.performRuntimeTypeCheck(model);
        DMNResultImpl result = this.createResult(model, context);
        for (DecisionNode decision : model.getDecisions()) {
            this.evaluateDecision(context, result, decision, performRuntimeTypeCheck);
        }
        return result;
    }

    public DMNResult evaluateDecisionByName(DMNModel model, String decisionName, DMNContext context) {
        return this.evaluateByName(model, context, decisionName);
    }

    public DMNResult evaluateDecisionById(DMNModel model, String decisionId, DMNContext context) {
        return this.evaluateById(model, context, decisionId);
    }

    public DMNResult evaluateByName(DMNModel model, DMNContext context, String ... decisionNames) {
        DMNResultImpl result = this.createResult(model, context);
        for (String name : decisionNames) {
            this.evaluateByNameInternal(model, context, result, name);
        }
        return result;
    }

    private void evaluateByNameInternal(DMNModel model, DMNContext context, DMNResultImpl result, String name) {
        boolean performRuntimeTypeCheck = this.performRuntimeTypeCheck(model);
        DecisionNode decision = model.getDecisionByName(name);
        if (decision != null) {
            this.evaluateDecision(context, result, decision, performRuntimeTypeCheck);
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, null, result, null, null, Msg.DECISION_NOT_FOUND_FOR_NAME, name);
        }
    }

    public DMNResult evaluateById(DMNModel model, DMNContext context, String ... decisionIds) {
        DMNResultImpl result = this.createResult(model, context);
        for (String id : decisionIds) {
            this.evaluateByIdInternal(model, context, result, id);
        }
        return result;
    }

    private void evaluateByIdInternal(DMNModel model, DMNContext context, DMNResultImpl result, String id) {
        boolean performRuntimeTypeCheck = this.performRuntimeTypeCheck(model);
        DecisionNode decision = model.getDecisionById(id);
        if (decision != null) {
            this.evaluateDecision(context, result, decision, performRuntimeTypeCheck);
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, null, result, null, null, Msg.DECISION_NOT_FOUND_FOR_ID, id);
        }
    }

    public void addListener(DMNRuntimeEventListener listener) {
        this.eventManager.addListener(listener);
    }

    public void removeListener(DMNRuntimeEventListener listener) {
        this.eventManager.removeListener(listener);
    }

    public Set<DMNRuntimeEventListener> getListeners() {
        return this.eventManager.getListeners();
    }

    private DMNResultImpl createResult(DMNModel model, DMNContext context) {
        DMNResultImpl result = new DMNResultImpl();
        result.setContext(context.clone());
        for (DecisionNode decision : model.getDecisions()) {
            result.setDecisionResult(decision.getId(), new DMNDecisionResultImpl(decision.getId(), decision.getName()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateBKM(DMNContext context, DMNResultImpl result, BusinessKnowledgeModelNode b, boolean typeCheck) {
        BusinessKnowledgeModelNodeImpl bkm = (BusinessKnowledgeModelNodeImpl)b;
        if (result.getContext().isDefined(bkm.getName())) {
            return;
        }
        if (bkm.getEvaluator() == null) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)bkm.getSource(), result, null, null, Msg.MISSING_EXPRESSION_FOR_BKM, this.getIdentifier(bkm));
            return;
        }
        try {
            DMNRuntimeEventManagerUtils.fireBeforeEvaluateBKM(this.eventManager, bkm, result);
            for (DMNNode dep : bkm.getDependencies().values()) {
                if (typeCheck && !this.checkDependencyValueIsValid(dep, result)) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)dep).getSource(), result, null, null, Msg.ERROR_EVAL_NODE_DEP_WRONG_TYPE, this.getIdentifier(bkm), this.getIdentifier(dep), MsgUtil.clipString(result.getContext().get(dep.getName()).toString(), 50), ((DMNBaseNode)dep).getType());
                    return;
                }
                if (result.getContext().isDefined(dep.getName())) continue;
                if (dep instanceof BusinessKnowledgeModelNode) {
                    this.evaluateBKM(context, result, (BusinessKnowledgeModelNode)dep, typeCheck);
                    continue;
                }
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)bkm.getSource(), result, null, null, Msg.REQ_DEP_NOT_FOUND_FOR_NODE, this.getIdentifier(dep), this.getIdentifier(bkm));
                return;
            }
            EvaluatorResult er = bkm.getEvaluator().evaluate((DMNRuntimeEventManager)this, result);
            if (er.getResultType() == EvaluatorResult.ResultType.SUCCESS) {
                FEELFunction resultFn = (FEELFunction)er.getResult();
                result.getContext().set(bkm.getBusinessKnowledModel().getVariable().getName(), (Object)resultFn);
            }
        }
        catch (Throwable t) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)bkm.getSource(), result, t, null, Msg.ERROR_EVAL_BKM_NODE, this.getIdentifier(bkm), t.getMessage());
        }
        finally {
            DMNRuntimeEventManagerUtils.fireAfterEvaluateBKM(this.eventManager, bkm, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean evaluateDecision(DMNContext context, DMNResultImpl result, DecisionNode d, boolean typeCheck) {
        block23: {
            block22: {
                block21: {
                    decision = (DecisionNodeImpl)d;
                    if (result.getContext().isDefined(decision.getName())) {
                        return true;
                    }
                    status = result.getDecisionResultById(decision.getId()).getEvaluationStatus();
                    if (DMNDecisionResult.DecisionEvaluationStatus.FAILED == status) return false;
                    if (DMNDecisionResult.DecisionEvaluationStatus.SKIPPED == status) return false;
                    if (DMNDecisionResult.DecisionEvaluationStatus.EVALUATING == status) {
                        return false;
                    }
                    DMNRuntimeEventManagerUtils.fireBeforeEvaluateDecision(this.eventManager, decision, result);
                    missingInput = false;
                    dr = (DMNDecisionResultImpl)result.getDecisionResultById(decision.getId());
                    dr.setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus.EVALUATING);
                    for (DMNNode dep : decision.getDependencies().values()) {
                        try {
                            if (typeCheck && !this.checkDependencyValueIsValid(dep, result)) {
                                missingInput = true;
                                message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)dep).getSource(), result, null, null, Msg.ERROR_EVAL_NODE_DEP_WRONG_TYPE, this.getIdentifier(decision), this.getIdentifier(dep), MsgUtil.clipString(result.getContext().get(dep.getName()).toString(), 50), ((DMNBaseNode)dep).getType());
                                this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                            }
                        }
                        catch (Exception e) {
                            MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)dep).getSource(), result, e, null, Msg.ERROR_CHECKING_ALLOWED_VALUES, this.getIdentifier(dep), e.getMessage());
                        }
                        if (result.getContext().isDefined(dep.getName())) continue;
                        if (dep instanceof DecisionNode) {
                            if (this.evaluateDecision(context, result, (DecisionNode)dep, typeCheck)) continue;
                            missingInput = true;
                            message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.UNABLE_TO_EVALUATE_DECISION_REQ_DEP, this.getIdentifier(decision), this.getIdentifier(dep));
                            this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                            continue;
                        }
                        if (dep instanceof BusinessKnowledgeModelNode) {
                            this.evaluateBKM(context, result, (BusinessKnowledgeModelNode)dep, typeCheck);
                            continue;
                        }
                        missingInput = true;
                        message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.REQ_DEP_NOT_FOUND_FOR_NODE, this.getIdentifier(dep), this.getIdentifier(decision));
                        this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                    }
                    if (missingInput) {
                        var8_10 = false;
                    }
                    ** GOTO lbl-1000
                    DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result);
                    return var8_10;
lbl-1000:
                    // 1 sources

                    {
                        if (decision.getEvaluator() != null) break block21;
                        message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.MISSING_EXPRESSION_FOR_DECISION, this.getIdentifier(decision));
                        this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                        dep = false;
                    }
                    DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result);
                    return dep;
                }
                er = decision.getEvaluator().evaluate((DMNRuntimeEventManager)this, result);
                if (er.getResultType() != EvaluatorResult.ResultType.SUCCESS) ** GOTO lbl80
                value = er.getResult();
                if (!decision.getResultType().isCollection() && value instanceof Collection && ((Collection)value).size() == 1) {
                    value = ((Collection)value).toArray()[0];
                }
                try {
                    if (!typeCheck || d.getResultType().isAssignableValue(value)) break block22;
                    message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.ERROR_EVAL_NODE_RESULT_WRONG_TYPE, this.getIdentifier(decision), decision.getResultType(), value);
                    this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.FAILED);
                    var11_19 = false;
                }
                catch (Exception e) {
                    MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, e, null, Msg.ERROR_CHECKING_ALLOWED_VALUES, this.getIdentifier(decision), e.getMessage());
                    var11_20 = false;
                    DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result);
                    return var11_20;
                }
                DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result);
                return var11_19;
            }
            result.getContext().set(decision.getDecision().getVariable().getName(), value);
            dr.setResult(value);
            dr.setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
            break block23;
lbl80:
            // 1 sources

            dr.setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus.FAILED);
            value = false;
            DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result);
            return value;
        }
        ** try [egrp 7[TRYBLOCK] [10 : 820->873)] { 
lbl86:
        // 1 sources

        return true;
        catch (Throwable t) {
            message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, t, null, Msg.ERROR_EVAL_DECISION_NODE, this.getIdentifier(decision), t.getMessage());
            this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.FAILED);
        }
        return true;
lbl91:
        // 1 sources

        finally {
            DMNRuntimeEventManagerUtils.fireAfterEvaluateDecision(this.eventManager, decision, result);
        }
    }

    private boolean checkDependencyValueIsValid(DMNNode dep, DMNResultImpl result) {
        if (dep instanceof InputDataNode) {
            InputDataNodeImpl inputDataNode = (InputDataNodeImpl)dep;
            BaseDMNTypeImpl dmnType = (BaseDMNTypeImpl)inputDataNode.getType();
            return dmnType.isAssignableValue(result.getContext().get(dep.getName()));
        }
        return true;
    }

    private String getIdentifier(DMNNode node) {
        return node.getName() != null ? node.getName() : node.getId();
    }

    private boolean performRuntimeTypeCheck(DMNModel model) {
        return this.overrideRuntimeTypeCheck || ((DMNModelImpl)model).isRuntimeTypeCheck();
    }

    public final <T extends DMNOption> void setOption(T option) {
        if (option instanceof RuntimeTypeCheckOption) {
            this.overrideRuntimeTypeCheck = ((RuntimeTypeCheckOption)option).isRuntimeTypeCheck();
        }
    }

    private void reportFailure(DMNDecisionResultImpl dr, DMNMessage message, DMNDecisionResult.DecisionEvaluationStatus status) {
        dr.getMessages().add(message);
        dr.setEvaluationStatus(status);
    }

    public DMNContext newContext() {
        return DMNFactory.newContext();
    }

    public DMNRuntime getRuntime() {
        return this;
    }

    public List<DMNProfile> getProfiles() {
        ArrayList<DMNProfile> profiles = new ArrayList<DMNProfile>();
        this.runtime.getKieBase().getKiePackages().forEach(kpkg -> {
            DMNPackageImpl dmnPkg = (DMNPackageImpl)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.DMN);
            if (dmnPkg != null) {
                for (DMNProfile p : dmnPkg.getProfiles()) {
                    if (profiles.contains(p)) continue;
                    profiles.add(p);
                }
            }
        });
        return profiles;
    }
}

