/*
 * Decompiled with CFR 0.152.
 */
package org.moditect;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.moditect.commands.AddModuleInfo;

public class Moditect {
    public static void main(String[] args) throws Exception {
        CliArgs cliArgs = new CliArgs();
        new JCommander((Object)cliArgs, args);
        new AddModuleInfo(null, null, null, null, cliArgs.outputDirecory, cliArgs.jvmVersion, cliArgs.overwriteExistingFiles, cliArgs.timestamp).run();
    }

    private static class InstantConverter
    implements IStringConverter<Instant> {
        private static final Instant DATE_MIN = Instant.parse("1980-01-01T00:00:02Z");
        private static final Instant DATE_MAX = Instant.parse("2099-12-31T23:59:59Z");

        private InstantConverter() {
        }

        public Instant convert(String value) {
            if (value == null) {
                return null;
            }
            if (!value.isEmpty() && this.isNumeric(value)) {
                return Instant.ofEpochSecond(Long.parseLong(value.trim()));
            }
            try {
                Instant date = OffsetDateTime.parse(value).withOffsetSameInstant(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS).toInstant();
                if (date.isBefore(DATE_MIN) || date.isAfter(DATE_MAX)) {
                    throw new IllegalArgumentException("'" + date + "' is not within the valid range " + DATE_MIN + " to " + DATE_MAX);
                }
                return date;
            }
            catch (DateTimeParseException pe) {
                throw new IllegalArgumentException("Invalid project.build.outputTimestamp value '" + value + "'", pe);
            }
        }

        private boolean isNumeric(String str) {
            try {
                Long.parseLong(str.trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    private static class PathConverter
    implements IStringConverter<Path> {
        private PathConverter() {
        }

        public Path convert(String value) {
            return Paths.get(value, new String[0]);
        }
    }

    @Parameters(separators="=")
    private static class CliArgs {
        @Parameter(names={"--module-info"}, required=true, description="Path to the module-info.java descriptor", converter=PathConverter.class)
        private Path moduleInfo;
        @Parameter(names={"--output-directory"}, required=true, description="Path to a directory for storing the modularized JAR", converter=PathConverter.class)
        private Path outputDirecory;
        @Parameter(names={"--jvm-version"}, required=false, description="The JVM version for which to add the module-info.java descriptor, or \"base\" to add the descriptor to the root of the jarfile (default: 9)")
        private String jvmVersion;
        @Parameter(names={"--overwrite-existing-files"}, required=false, description="Whether to overwrite existing files or not")
        private boolean overwriteExistingFiles;
        @Parameter(names={"--timestamp"}, required=false, description="Timestamp used when writing archive entries", converter=InstantConverter.class)
        private Instant timestamp;

        private CliArgs() {
        }
    }
}

