/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.moditect.internal.compiler.ModuleInfoCompiler;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleDeclaration;

public class AddModuleInfo {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final String NO_JVM_VERSION = "base";
    private static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final String META_INF_VERSIONS_DIR = "META-INF/versions/";
    private static final String MODULE_INFO_CLASS = "module-info.class";
    private final String moduleInfoSource;
    private final String mainClass;
    private final String version;
    private final Path inputJar;
    private final Path outputDirectory;
    private final Integer jvmVersion;
    private final boolean overwriteExistingFiles;
    private final Instant timestamp;

    public AddModuleInfo(String moduleInfoSource, String mainClass, String version, Path inputJar, Path outputDirectory, String jvmVersion, boolean overwriteExistingFiles, Instant timestamp) {
        this.moduleInfoSource = moduleInfoSource;
        this.mainClass = mainClass;
        this.version = version;
        this.inputJar = inputJar;
        this.outputDirectory = outputDirectory;
        if (jvmVersion == null || jvmVersion.equals(NO_JVM_VERSION)) {
            this.jvmVersion = null;
        } else {
            try {
                this.jvmVersion = Integer.valueOf(jvmVersion);
                if (this.jvmVersion < 9) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid JVM Version: " + jvmVersion + ". Allowed values are 'base' and integer values >= 9.");
            }
        }
        this.overwriteExistingFiles = overwriteExistingFiles;
        this.timestamp = timestamp;
    }

    public void run() {
        if (Files.isDirectory(this.inputJar, new LinkOption[0])) {
            throw new IllegalArgumentException("Input JAR must not be a directory");
        }
        if (!Files.exists(this.outputDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Output directory doesn't exist: " + this.outputDirectory);
        }
        Path outputJar = this.outputDirectory.resolve(this.inputJar.getFileName());
        if (Files.exists(outputJar, new LinkOption[0]) && !this.overwriteExistingFiles) {
            throw new RuntimeException("File " + outputJar + " already exists; either set 'overwriteExistingFiles' to true or specify another output directory");
        }
        ModuleDeclaration module = ModuleInfoCompiler.parseModuleInfo(this.moduleInfoSource);
        byte[] clazz = ModuleInfoCompiler.compileModuleInfo(module, this.mainClass, this.version);
        Path tmpOutputJar = null;
        try {
            tmpOutputJar = Files.createTempFile("moditect", "jar", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't create tmp JAR file", e);
        }
        boolean versionedModuleInfo = this.jvmVersion != null;
        String moduleInfoDir = versionedModuleInfo ? META_INF_VERSIONS_DIR + this.jvmVersion + "/" : "";
        String moduleInfoEntryName = moduleInfoDir + MODULE_INFO_CLASS;
        long lastModifiedTime = this.toFileTime(this.timestamp).toMillis();
        List<Object> dirEntriesToCreate = Collections.emptyList();
        if (versionedModuleInfo) {
            dirEntriesToCreate = Arrays.asList(META_INF_VERSIONS_DIR, moduleInfoDir);
        }
        HashSet<String> overwrittenEntries = new HashSet<String>();
        overwrittenEntries.add(moduleInfoEntryName);
        overwrittenEntries.addAll(dirEntriesToCreate);
        try (JarFile jarFile = new JarFile(this.inputJar.toAbsolutePath().toFile());
             JarOutputStream jarout = new JarOutputStream(Files.newOutputStream(tmpOutputJar.toAbsolutePath(), StandardOpenOption.TRUNCATE_EXISTING));){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry inputEntry = entries.nextElement();
                String string = inputEntry.getName();
                if (versionedModuleInfo && MANIFEST_ENTRY_NAME.equals(string)) {
                    Manifest manifest = jarFile.getManifest();
                    if (null == manifest) {
                        manifest = new Manifest();
                        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                    }
                    manifest.getMainAttributes().put(new Attributes.Name("Multi-Release"), "true");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    JarEntry outputEntry = new JarEntry(string);
                    outputEntry.setTime(lastModifiedTime);
                    jarout.putNextEntry(outputEntry);
                    jarout.write(baos.toByteArray(), 0, baos.size());
                    jarout.closeEntry();
                    continue;
                }
                if (overwrittenEntries.contains(string)) continue;
                JarEntry outputEntry = new JarEntry(string);
                outputEntry.setTime(lastModifiedTime);
                jarout.putNextEntry(outputEntry);
                this.copy(jarFile.getInputStream(inputEntry), jarout);
                jarout.closeEntry();
            }
            for (String string : dirEntriesToCreate) {
                JarEntry dirEntry = new JarEntry(string);
                dirEntry.setTime(lastModifiedTime);
                jarout.putNextEntry(dirEntry);
                jarout.closeEntry();
            }
            JarEntry outputEntry = new JarEntry(moduleInfoEntryName);
            outputEntry.setTime(lastModifiedTime);
            jarout.putNextEntry(outputEntry);
            jarout.write(clazz, 0, clazz.length);
            jarout.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't add module-info.class to JAR", e);
        }
        try {
            Files.createDirectories(outputJar.toAbsolutePath().getParent(), new FileAttribute[0]);
            Files.move(tmpOutputJar, outputJar, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't copy JAR file", e);
        }
    }

    private FileTime toFileTime(Instant timestamp) {
        return FileTime.from(timestamp != null ? timestamp : Instant.now());
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
        }
    }
}

