/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.spi.ToolProvider;
import java.util.stream.Collectors;
import org.moditect.internal.analyzer.ServiceLoaderUseScanner;
import org.moditect.internal.command.LogWriter;
import org.moditect.internal.compiler.ModuleInfoCompiler;
import org.moditect.internal.parser.JdepsExtraArgsExtractor;
import org.moditect.internal.shaded.javaparser.StaticJavaParser;
import org.moditect.internal.shaded.javaparser.ast.Modifier;
import org.moditect.internal.shaded.javaparser.ast.NodeList;
import org.moditect.internal.shaded.javaparser.ast.expr.Name;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleDeclaration;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleExportsDirective;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleOpensDirective;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleProvidesDirective;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleRequiresDirective;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleUsesDirective;
import org.moditect.model.DependencePattern;
import org.moditect.model.DependencyDescriptor;
import org.moditect.model.GeneratedModuleInfo;
import org.moditect.model.PackageNamePattern;
import org.moditect.spi.log.Log;

public class GenerateModuleInfo {
    private final Path inputJar;
    private final String autoModuleNameForInputJar;
    private final String moduleName;
    private final boolean open;
    private final Set<DependencyDescriptor> dependencies;
    private final List<PackageNamePattern> exportPatterns;
    private final List<PackageNamePattern> opensPatterns;
    private final List<DependencePattern> requiresPatterns;
    private final Set<String> opensResources;
    private final Set<String> uses;
    private final Set<String> provides;
    private final Path workingDirectory;
    private final Path outputDirectory;
    private final boolean addServiceUses;
    private final ServiceLoaderUseScanner serviceLoaderUseScanner;
    private final List<String> jdepsExtraArgs;
    private final Log log;
    private ToolProvider jdeps;

    public GenerateModuleInfo(Path inputJar, String moduleName, boolean open, Set<DependencyDescriptor> dependencies, List<PackageNamePattern> exportPatterns, List<PackageNamePattern> opensPatterns, List<DependencePattern> requiresPatterns, Path workingDirectory, Path outputDirectory, Set<String> opensResources, Set<String> uses, Set<String> provides, boolean addServiceUses, List<String> jdepsExtraArgs, Log log) {
        String autoModuleNameForInputJar = DependencyDescriptor.getAutoModuleNameFromInputJar(inputJar, null);
        if (autoModuleNameForInputJar != null) {
            this.autoModuleNameForInputJar = autoModuleNameForInputJar;
            this.inputJar = inputJar;
        } else {
            this.autoModuleNameForInputJar = moduleName;
            this.inputJar = GenerateModuleInfo.createCopyWithAutoModuleNameManifestHeader(workingDirectory, inputJar, moduleName);
        }
        this.moduleName = moduleName;
        this.open = open;
        this.dependencies = dependencies;
        this.exportPatterns = exportPatterns;
        this.opensPatterns = opensPatterns;
        this.requiresPatterns = requiresPatterns;
        this.workingDirectory = workingDirectory;
        this.outputDirectory = outputDirectory;
        this.opensResources = opensResources;
        this.uses = uses;
        this.provides = provides;
        this.addServiceUses = addServiceUses;
        this.serviceLoaderUseScanner = new ServiceLoaderUseScanner(log);
        this.jdepsExtraArgs = jdepsExtraArgs != null ? jdepsExtraArgs : Collections.emptyList();
        this.log = log;
        Optional<ToolProvider> jdeps = ToolProvider.findFirst("jdeps");
        if (!jdeps.isPresent()) {
            throw new RuntimeException("jdeps tool not found");
        }
        this.jdeps = jdeps.get();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Path createCopyWithAutoModuleNameManifestHeader(Path workingDirectory, Path inputJar, String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException("No automatic name can be derived for the JAR " + inputJar + ", hence an explicit module name is required");
        }
        Path copiedJar = GenerateModuleInfo.createCopy(workingDirectory, inputJar);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + copiedJar.toUri().toString());
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, env);){
            Path path;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Manifest manifest = GenerateModuleInfo.getManifest(inputJar);
                manifest.getMainAttributes().putValue("Automatic-Module-Name", moduleName);
                manifest.write(baos);
                Files.write(zipfs.getPath("META-INF", "MANIFEST.MF"), baos.toByteArray(), new OpenOption[0]);
                path = copiedJar;
            }
            return path;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't inject automatic module name into manifest", ioe);
        }
    }

    private static Path createCopy(Path workingDirectory, Path inputJar) {
        try {
            Path tempDir = Files.createTempDirectory(workingDirectory, null, new FileAttribute[0]);
            Path copiedJar = tempDir.resolve(inputJar.getFileName());
            Files.copy(inputJar, copiedJar, new CopyOption[0]);
            return copiedJar;
        }
        catch (IOException ieo) {
            throw new RuntimeException(ieo);
        }
    }

    private static Manifest getManifest(Path inputJar) throws IOException {
        try (JarInputStream jar = new JarInputStream(Files.newInputStream(inputJar, new OpenOption[0]));){
            Manifest manifest = jar.getManifest();
            Manifest manifest2 = manifest != null ? manifest : new Manifest();
            return manifest2;
        }
    }

    public GeneratedModuleInfo run() {
        if (Files.isDirectory(this.inputJar, new LinkOption[0])) {
            throw new IllegalArgumentException("Input JAR must not be a directory");
        }
        if (!Files.exists(this.workingDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Working directory doesn't exist: " + this.workingDirectory);
        }
        if (!Files.exists(this.outputDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Output directory doesn't exist: " + this.outputDirectory);
        }
        Map<String, Boolean> optionalityPerModule = this.generateModuleInfo();
        ModuleDeclaration moduleDeclaration = this.parseGeneratedModuleInfo();
        this.updateModuleInfo(optionalityPerModule, moduleDeclaration);
        return this.writeModuleInfo(moduleDeclaration);
    }

    private void updateModuleInfo(Map<String, Boolean> optionalityPerModule, ModuleDeclaration moduleDeclaration) {
        if (this.open) {
            moduleDeclaration.setOpen(true);
        }
        List<ModuleRequiresDirective> requiresStatements = moduleDeclaration.findAll(ModuleRequiresDirective.class);
        block0: for (ModuleRequiresDirective moduleRequiresDirective : requiresStatements) {
            if (Boolean.TRUE.equals(optionalityPerModule.get(moduleRequiresDirective.getNameAsString()))) {
                moduleRequiresDirective.addModifier(Modifier.Keyword.STATIC);
            }
            for (DependencyDescriptor dependency : this.dependencies) {
                if (!dependency.getOriginalModuleName().equals(moduleRequiresDirective.getNameAsString()) || dependency.getAssignedModuleName() == null) continue;
                moduleRequiresDirective.setName(dependency.getAssignedModuleName());
            }
            for (DependencePattern dependence : this.requiresPatterns) {
                if (!dependence.matches(moduleRequiresDirective.getNameAsString())) continue;
                if (!dependence.isInclusive()) {
                    moduleDeclaration.remove(moduleRequiresDirective);
                }
                if (dependence.isMatchAll() && dependence.getModifiers().isEmpty()) {
                    moduleRequiresDirective.removeModifier(Modifier.Keyword.TRANSITIVE);
                    continue block0;
                }
                moduleRequiresDirective.getModifiers().clear();
                dependence.getModifiers().stream().map(m -> Modifier.Keyword.valueOf(m.toUpperCase(Locale.ENGLISH))).forEach(m -> moduleRequiresDirective.addModifier((Modifier.Keyword)((Object)((Object)m))));
                continue block0;
            }
        }
        List<ModuleExportsDirective> exportStatements = moduleDeclaration.findAll(ModuleExportsDirective.class);
        for (ModuleExportsDirective moduleExportsDirective : exportStatements) {
            this.applyExportPatterns(moduleDeclaration, moduleExportsDirective);
            this.applyOpensPatterns(moduleDeclaration, moduleExportsDirective);
        }
        if (this.moduleName != null) {
            moduleDeclaration.setName(this.moduleName);
        }
        this.opensResources.stream().forEach(resourcePackage -> moduleDeclaration.getDirectives().add(new ModuleOpensDirective(StaticJavaParser.parseName(resourcePackage), new NodeList<Name>())));
        for (String usedService : this.uses) {
            moduleDeclaration.getDirectives().add(new ModuleUsesDirective(StaticJavaParser.parseName(usedService)));
        }
        this.provides.stream().map(providedService -> providedService.split("\\s+with\\s+")).forEach(providedServiceArray -> moduleDeclaration.getDirectives().add(new ModuleProvidesDirective(StaticJavaParser.parseName(providedServiceArray[0]), NodeList.nodeList(Arrays.stream(providedServiceArray[1].split(",")).map(String::trim).map(s -> StaticJavaParser.parseName(s)).collect(Collectors.toSet())))));
        if (this.addServiceUses) {
            Set<String> set = this.serviceLoaderUseScanner.getUsedServices(this.inputJar);
            for (String usedService : set) {
                moduleDeclaration.getDirectives().add(new ModuleUsesDirective(StaticJavaParser.parseName(usedService)));
            }
        }
    }

    private ModuleDeclaration applyExportPatterns(ModuleDeclaration moduleDeclaration, ModuleExportsDirective moduleExportsDirective) {
        boolean foundMatchingPattern = false;
        for (PackageNamePattern pattern : this.exportPatterns) {
            if (!pattern.matches(moduleExportsDirective.getNameAsString())) continue;
            if (pattern.getKind() == PackageNamePattern.Kind.INCLUSIVE) {
                if (!pattern.getTargetModules().isEmpty()) {
                    for (String module : pattern.getTargetModules()) {
                        moduleExportsDirective.getModuleNames().add(StaticJavaParser.parseName(module));
                    }
                }
            } else {
                moduleDeclaration.remove(moduleExportsDirective);
            }
            foundMatchingPattern = true;
            break;
        }
        if (!foundMatchingPattern) {
            moduleDeclaration.remove(moduleExportsDirective);
        }
        return moduleDeclaration;
    }

    private ModuleDeclaration applyOpensPatterns(ModuleDeclaration moduleDeclaration, ModuleExportsDirective moduleExportsDirective) {
        for (PackageNamePattern pattern : this.opensPatterns) {
            if (!pattern.matches(moduleExportsDirective.getNameAsString())) continue;
            if (pattern.getKind() != PackageNamePattern.Kind.INCLUSIVE) break;
            ModuleOpensDirective moduleOpensDirective = new ModuleOpensDirective();
            moduleOpensDirective.setName(moduleExportsDirective.getName());
            if (!pattern.getTargetModules().isEmpty()) {
                for (String module : pattern.getTargetModules()) {
                    moduleOpensDirective.getModuleNames().add(StaticJavaParser.parseName(module));
                }
            }
            moduleDeclaration.getDirectives().add(moduleOpensDirective);
            break;
        }
        return moduleDeclaration;
    }

    private Map<String, Boolean> generateModuleInfo() throws AssertionError {
        HashMap<String, Boolean> optionalityPerModule = new HashMap<String, Boolean>();
        ArrayList<String> command = new ArrayList<String>();
        command.add("--generate-module-info");
        command.add(this.workingDirectory.toString());
        if (!this.dependencies.isEmpty()) {
            StringBuilder modules = new StringBuilder();
            StringBuilder modulePath = new StringBuilder();
            boolean isFirst = true;
            for (DependencyDescriptor dependency : this.dependencies) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    modules.append(",");
                    modulePath.append(File.pathSeparator);
                }
                String moduleName = DependencyDescriptor.getAutoModuleNameFromInputJar(dependency.getPath(), dependency.getAssignedModuleName());
                modules.append(moduleName);
                optionalityPerModule.put(moduleName, dependency.isOptional());
                modulePath.append(dependency.getPath());
            }
            command.add("--add-modules");
            command.add(modules.toString());
            command.add("--module-path");
            command.add(modulePath.toString());
        }
        command.addAll(this.jdepsExtraArgs);
        command.add(this.inputJar.toString());
        this.log.info("Running jdeps " + String.join((CharSequence)" ", command));
        LogWriter out = new LogWriter(this.log);
        int result = this.jdeps.run(out, out, command.toArray(new String[0]));
        if (result != 0) {
            throw new IllegalStateException("Invocation of jdeps failed: jdeps " + String.join((CharSequence)" ", command));
        }
        return optionalityPerModule;
    }

    private ModuleDeclaration parseGeneratedModuleInfo() {
        Path versionsModuleInfo;
        Path moduleDir = this.workingDirectory.resolve(this.autoModuleNameForInputJar);
        Path moduleInfo = moduleDir.resolve("module-info.java");
        Optional<Integer> multiReleaseVersion = new JdepsExtraArgsExtractor(this.log).extractVersion(this.jdepsExtraArgs);
        if (multiReleaseVersion.isPresent() && Files.exists(versionsModuleInfo = moduleDir.resolve("versions").resolve(multiReleaseVersion.get().toString()).resolve("module-info.java"), new LinkOption[0])) {
            moduleInfo = versionsModuleInfo;
        }
        return ModuleInfoCompiler.parseModuleInfo(moduleInfo);
    }

    private GeneratedModuleInfo writeModuleInfo(ModuleDeclaration moduleDeclaration) {
        Path outputModuleInfo = this.recreateDirectory(this.outputDirectory, moduleDeclaration.getNameAsString()).resolve("module-info.java");
        try {
            Files.write(outputModuleInfo, moduleDeclaration.toString().getBytes(), new OpenOption[0]);
            this.log.info("Created module descriptor at " + outputModuleInfo);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write module-info.java", e);
        }
        return new GeneratedModuleInfo(moduleDeclaration.getNameAsString(), outputModuleInfo);
    }

    private Path recreateDirectory(Path parent, String directoryName) {
        Path dir = parent.resolve(directoryName);
        try {
            if (Files.exists(dir, new LinkOption[0])) {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't recreate directory " + dir, e);
        }
        return dir;
    }
}

