/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.spi.ToolProvider;
import java.util.stream.Collectors;
import org.moditect.internal.command.LogWriter;
import org.moditect.model.Version;
import org.moditect.spi.log.Log;

public class GenerateModuleList {
    private final Path projectJar;
    private final Set<Path> dependencies;
    private final Version jvmVersion;
    private final Log log;
    private final ToolProvider jdeps;

    public GenerateModuleList(Path projectJar, Set<Path> dependencies, Version jvmVersion, Log log) {
        this.projectJar = projectJar;
        this.dependencies = dependencies;
        this.jvmVersion = jvmVersion;
        this.log = log;
        this.jdeps = ToolProvider.findFirst("jdeps").orElseThrow(() -> new RuntimeException("jdeps tool not found"));
    }

    public void run() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        this.jdeps.run(out, System.err, "--version");
        out.close();
        int jdepsVersion = Runtime.Version.parse(outStream.toString().strip()).feature();
        if (jdepsVersion < 12) {
            this.log.error("The jdeps option this plugin uses to list JDK modules only works flawlessly on JDK 12+, so please use that to run this goal.");
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("--print-module-deps");
        command.add("--ignore-missing-deps");
        command.add("--multi-release");
        command.add(String.valueOf(this.jvmVersion.feature()));
        command.add("--class-path");
        String classPath = this.dependencies.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        command.add(classPath);
        command.add(this.projectJar.toAbsolutePath().toString());
        this.log.debug("Running jdeps " + String.join((CharSequence)" ", command));
        LogWriter logWriter = new LogWriter(this.log);
        int result = this.jdeps.run(logWriter, logWriter, command.toArray(new String[0]));
        if (result != 0) {
            throw new IllegalStateException("Invocation of jdeps failed: jdeps " + String.join((CharSequence)" ", command));
        }
    }
}

