/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.compiler;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import org.moditect.internal.shaded.asm.ClassWriter;
import org.moditect.internal.shaded.asm.ModuleVisitor;
import org.moditect.internal.shaded.javaparser.ParserConfiguration;
import org.moditect.internal.shaded.javaparser.StaticJavaParser;
import org.moditect.internal.shaded.javaparser.ast.CompilationUnit;
import org.moditect.internal.shaded.javaparser.ast.Modifier;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.ast.expr.Name;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleDeclaration;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleExportsDirective;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleOpensDirective;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleProvidesDirective;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleRequiresDirective;
import org.moditect.internal.shaded.javaparser.ast.modules.ModuleUsesDirective;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.NodeWithModifiers;

public class ModuleInfoCompiler {
    public static ModuleDeclaration parseModuleInfo(Path moduleInfo) {
        CompilationUnit ast;
        try {
            ast = StaticJavaParser.parse(moduleInfo);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't parse " + moduleInfo, e);
        }
        return ast.getModule().orElseThrow(() -> new IllegalArgumentException("Not a module-info.java: " + moduleInfo));
    }

    public static ModuleDeclaration parseModuleInfo(String moduleInfoSource) {
        CompilationUnit ast = StaticJavaParser.parse(moduleInfoSource);
        return ast.getModule().orElseThrow(() -> new IllegalArgumentException("Not a module-info.java: " + moduleInfoSource));
    }

    public static byte[] compileModuleInfo(ModuleDeclaration module, String mainClass, String version) {
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(53, 32768, "module-info", null, null, null);
        int moduleAccess = module.isOpen() ? 4128 : 4096;
        ModuleVisitor mv = classWriter.visitModule(module.getNameAsString(), moduleAccess, version);
        if (mainClass != null) {
            mv.visitMainClass(ModuleInfoCompiler.getNameForBinary(mainClass, Kind.CLASS));
        }
        for (ModuleRequiresDirective requires : module.findAll(ModuleRequiresDirective.class)) {
            mv.visitRequire(requires.getName().asString(), ModuleInfoCompiler.requiresModifiersAsInt(requires), null);
        }
        for (ModuleExportsDirective export : module.findAll(ModuleExportsDirective.class)) {
            mv.visitExport(ModuleInfoCompiler.getNameForBinary(export.getNameAsString(), Kind.PACKAGE), 0, (String[])export.getModuleNames().stream().map(Node::toString).toArray(String[]::new));
        }
        for (ModuleProvidesDirective provides : module.findAll(ModuleProvidesDirective.class)) {
            mv.visitProvide(ModuleInfoCompiler.getNameForBinary(provides.getName(), Kind.CLASS), (String[])provides.getWith().stream().map(name -> ModuleInfoCompiler.getNameForBinary(name, Kind.CLASS)).toArray(String[]::new));
        }
        for (ModuleUsesDirective uses : module.findAll(ModuleUsesDirective.class)) {
            mv.visitUse(ModuleInfoCompiler.getNameForBinary(uses.getName(), Kind.CLASS));
        }
        for (ModuleOpensDirective opens : module.findAll(ModuleOpensDirective.class)) {
            mv.visitOpen(ModuleInfoCompiler.getNameForBinary(opens.getNameAsString(), Kind.PACKAGE), 0, (String[])opens.getModuleNames().stream().map(Node::toString).toArray(String[]::new));
        }
        mv.visitRequire("java.base", 32768, null);
        mv.visitEnd();
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static String getNameForBinary(Name name, Kind kind) {
        return ModuleInfoCompiler.getNameForBinary(name.asString(), kind);
    }

    private static String getNameForBinary(String typeName, Kind kind) {
        Iterator<String> parts = Arrays.asList(typeName.split("\\.")).iterator();
        StringBuilder typeNameForBinary = new StringBuilder();
        while (parts.hasNext()) {
            String part = parts.next();
            typeNameForBinary.append(part);
            if (!parts.hasNext()) continue;
            if (kind == Kind.CLASS && Character.isUpperCase(part.charAt(0))) {
                typeNameForBinary.append("$");
                continue;
            }
            typeNameForBinary.append("/");
        }
        return typeNameForBinary.toString();
    }

    private static int requiresModifiersAsInt(NodeWithModifiers<?> modifiers) {
        int result = 0;
        if (modifiers.hasModifier(Modifier.Keyword.STATIC)) {
            result |= 0x40;
        }
        if (modifiers.hasModifier(Modifier.Keyword.TRANSITIVE)) {
            result |= 0x20;
        }
        return result;
    }

    static {
        StaticJavaParser.getConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_9);
    }

    private static enum Kind {
        CLASS,
        PACKAGE;

    }
}

