/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.parser;

import java.util.List;
import java.util.Optional;
import org.moditect.spi.log.Log;

public final class JdepsExtraArgsExtractor {
    public static final String MULTI_RELEASE_ARGUMENT = "--multi-release";
    private final Log log;

    public JdepsExtraArgsExtractor(Log log) {
        this.log = log;
    }

    public Optional<Integer> extractVersion(List<String> jdepsExtraArgs) {
        for (int i = 0; i < jdepsExtraArgs.size(); ++i) {
            String extraArg = jdepsExtraArgs.get(i);
            if (!extraArg.startsWith(MULTI_RELEASE_ARGUMENT)) continue;
            if (extraArg.length() == MULTI_RELEASE_ARGUMENT.length()) {
                return this.extractVersionFromNextArgument(jdepsExtraArgs, i);
            }
            return this.extractVersionFromSameArgument(extraArg);
        }
        this.debug("No version can be extracted from arguments: " + jdepsExtraArgs);
        return Optional.empty();
    }

    private Optional<Integer> extractVersionFromNextArgument(List<String> jdepsExtraArgs, int i) {
        if (i == jdepsExtraArgs.size() - 1) {
            this.error("No argument value for --multi-release");
            return Optional.empty();
        }
        String versionString = jdepsExtraArgs.get(i + 1);
        this.debug("Version extracted from the next argument: " + versionString);
        return this.parseVersionNumber(versionString);
    }

    private Optional<Integer> extractVersionFromSameArgument(String multiReleaseArgument) {
        if (multiReleaseArgument.length() < MULTI_RELEASE_ARGUMENT.length() + 2) {
            this.error("Invalid argument value for --multi-release: " + multiReleaseArgument);
            return Optional.empty();
        }
        String versionString = multiReleaseArgument.substring(MULTI_RELEASE_ARGUMENT.length() + 1);
        this.debug("Version extracted from the same argument: " + versionString);
        return this.parseVersionNumber(versionString);
    }

    private Optional<Integer> parseVersionNumber(String versionString) {
        if ("base".equals(versionString)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(versionString));
        }
        catch (NumberFormatException ex) {
            this.error("Invalid argument value for --multi-release: " + versionString);
            return Optional.empty();
        }
    }

    private void debug(String message) {
        if (this.log != null) {
            this.log.debug(message);
        }
    }

    private void error(String message) {
        if (this.log != null) {
            this.log.error(message);
        }
    }
}

