/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.moditect.internal.shaded.javaparser.TokenRange;
import org.moditect.internal.shaded.javaparser.ast.AllFieldsConstructor;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.ast.NodeList;
import org.moditect.internal.shaded.javaparser.ast.expr.Expression;
import org.moditect.internal.shaded.javaparser.ast.expr.SimpleName;
import org.moditect.internal.shaded.javaparser.ast.expr.ThisExpr;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.NodeWithScope;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.NodeWithSimpleName;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import org.moditect.internal.shaded.javaparser.ast.observer.ObservableProperty;
import org.moditect.internal.shaded.javaparser.ast.type.Type;
import org.moditect.internal.shaded.javaparser.ast.visitor.CloneVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.GenericVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.VoidVisitor;
import org.moditect.internal.shaded.javaparser.metamodel.FieldAccessExprMetaModel;
import org.moditect.internal.shaded.javaparser.metamodel.JavaParserMetaModel;
import org.moditect.internal.shaded.javaparser.metamodel.OptionalProperty;
import org.moditect.internal.shaded.javaparser.resolution.Resolvable;
import org.moditect.internal.shaded.javaparser.resolution.declarations.ResolvedValueDeclaration;
import org.moditect.internal.shaded.javaparser.utils.Utils;

public class FieldAccessExpr
extends Expression
implements NodeWithSimpleName<FieldAccessExpr>,
NodeWithTypeArguments<FieldAccessExpr>,
NodeWithScope<FieldAccessExpr>,
Resolvable<ResolvedValueDeclaration> {
    private Expression scope;
    @OptionalProperty
    private NodeList<Type> typeArguments;
    private SimpleName name;

    public FieldAccessExpr() {
        this(null, new ThisExpr(), null, new SimpleName());
    }

    public FieldAccessExpr(Expression scope, String name) {
        this(null, scope, null, new SimpleName(name));
    }

    @AllFieldsConstructor
    public FieldAccessExpr(Expression scope, NodeList<Type> typeArguments, SimpleName name) {
        this(null, scope, typeArguments, name);
    }

    public FieldAccessExpr(TokenRange tokenRange, Expression scope, NodeList<Type> typeArguments, SimpleName name) {
        super(tokenRange);
        this.setScope(scope);
        this.setTypeArguments((NodeList)typeArguments);
        this.setName(name);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public FieldAccessExpr setName(SimpleName name) {
        Utils.assertNotNull(name);
        if (name == this.name) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return this;
    }

    @Override
    public Expression getScope() {
        return this.scope;
    }

    @Override
    public FieldAccessExpr setScope(Expression scope) {
        Utils.assertNotNull(scope);
        if (scope == this.scope) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.SCOPE, this.scope, scope);
        if (this.scope != null) {
            this.scope.setParentNode(null);
        }
        this.scope = scope;
        this.setAsParentNodeOf(scope);
        return this;
    }

    @Override
    public Optional<NodeList<Type>> getTypeArguments() {
        return Optional.ofNullable(this.typeArguments);
    }

    @Override
    public FieldAccessExpr setTypeArguments(NodeList<Type> typeArguments) {
        if (typeArguments == this.typeArguments) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE_ARGUMENTS, this.typeArguments, typeArguments);
        if (this.typeArguments != null) {
            this.typeArguments.setParentNode(null);
        }
        this.typeArguments = typeArguments;
        this.setAsParentNodeOf(typeArguments);
        return this;
    }

    @Override
    public FieldAccessExpr clone() {
        return (FieldAccessExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public FieldAccessExprMetaModel getMetaModel() {
        return JavaParserMetaModel.fieldAccessExprMetaModel;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.typeArguments != null) {
            for (int i = 0; i < this.typeArguments.size(); ++i) {
                if (this.typeArguments.get(i) != node) continue;
                this.typeArguments.remove(i);
                return true;
            }
        }
        return super.remove(node);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (node == this.name) {
            this.setName((SimpleName)replacementNode);
            return true;
        }
        if (node == this.scope) {
            this.setScope((Expression)replacementNode);
            return true;
        }
        if (this.typeArguments != null) {
            for (int i = 0; i < this.typeArguments.size(); ++i) {
                if (this.typeArguments.get(i) != node) continue;
                this.typeArguments.set(i, (Type)replacementNode);
                return true;
            }
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isFieldAccessExpr() {
        return true;
    }

    @Override
    public FieldAccessExpr asFieldAccessExpr() {
        return this;
    }

    @Override
    public void ifFieldAccessExpr(Consumer<FieldAccessExpr> action) {
        action.accept(this);
    }

    @Override
    public ResolvedValueDeclaration resolve() {
        return this.getSymbolResolver().resolveDeclaration(this, ResolvedValueDeclaration.class);
    }

    @Override
    public Optional<FieldAccessExpr> toFieldAccessExpr() {
        return Optional.of(this);
    }

    public boolean isInternal() {
        return this.getParentNode().isPresent() && this.getParentNode().get() instanceof FieldAccessExpr;
    }

    public boolean isTopLevel() {
        return !this.isInternal();
    }
}

