/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.moditect.internal.shaded.javaparser.TokenRange;
import org.moditect.internal.shaded.javaparser.ast.AllFieldsConstructor;
import org.moditect.internal.shaded.javaparser.ast.Modifier;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.ast.NodeList;
import org.moditect.internal.shaded.javaparser.ast.expr.PatternExpr;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.modifiers.NodeWithFinalModifier;
import org.moditect.internal.shaded.javaparser.ast.observer.ObservableProperty;
import org.moditect.internal.shaded.javaparser.ast.type.ClassOrInterfaceType;
import org.moditect.internal.shaded.javaparser.ast.type.ReferenceType;
import org.moditect.internal.shaded.javaparser.ast.type.Type;
import org.moditect.internal.shaded.javaparser.ast.visitor.CloneVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.GenericVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.VoidVisitor;
import org.moditect.internal.shaded.javaparser.metamodel.JavaParserMetaModel;
import org.moditect.internal.shaded.javaparser.metamodel.RecordPatternExprMetaModel;
import org.moditect.internal.shaded.javaparser.utils.Utils;

public class RecordPatternExpr
extends PatternExpr
implements NodeWithFinalModifier<RecordPatternExpr> {
    private NodeList<Modifier> modifiers;
    private NodeList<PatternExpr> patternList;

    public RecordPatternExpr() {
        this(new NodeList<Modifier>(), new ClassOrInterfaceType(), new NodeList<PatternExpr>());
    }

    @AllFieldsConstructor
    public RecordPatternExpr(NodeList<Modifier> modifiers, Type type, NodeList<PatternExpr> patternList) {
        this(null, modifiers, type, patternList);
    }

    @Override
    public ReferenceType getType() {
        return super.getType().asReferenceType();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public NodeList<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public RecordPatternExpr setModifiers(NodeList<Modifier> modifiers) {
        Utils.assertNotNull(modifiers);
        if (modifiers == this.modifiers) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        if (this.modifiers != null) {
            this.modifiers.setParentNode(null);
        }
        this.modifiers = modifiers;
        this.setAsParentNodeOf(modifiers);
        return this;
    }

    @Override
    public boolean isRecordPatternExpr() {
        return true;
    }

    @Override
    public RecordPatternExpr asRecordPatternExpr() {
        return this;
    }

    @Override
    public Optional<RecordPatternExpr> toRecordPatternExpr() {
        return Optional.of(this);
    }

    @Override
    public void ifRecordPatternExpr(Consumer<RecordPatternExpr> action) {
        action.accept(this);
    }

    public NodeList<PatternExpr> getPatternList() {
        return this.patternList;
    }

    public RecordPatternExpr setPatternList(NodeList<PatternExpr> patternList) {
        Utils.assertNotNull(patternList);
        if (patternList == this.patternList) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.PATTERN_LIST, this.patternList, patternList);
        if (this.patternList != null) {
            this.patternList.setParentNode(null);
        }
        this.patternList = patternList;
        this.setAsParentNodeOf(patternList);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.modifiers.size(); ++i) {
            if (this.modifiers.get(i) != node) continue;
            this.modifiers.remove(i);
            return true;
        }
        for (i = 0; i < this.patternList.size(); ++i) {
            if (this.patternList.get(i) != node) continue;
            this.patternList.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.modifiers.size(); ++i) {
            if (this.modifiers.get(i) != node) continue;
            this.modifiers.set(i, (Modifier)replacementNode);
            return true;
        }
        for (i = 0; i < this.patternList.size(); ++i) {
            if (this.patternList.get(i) != node) continue;
            this.patternList.set(i, (PatternExpr)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public RecordPatternExpr clone() {
        return (RecordPatternExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public RecordPatternExprMetaModel getMetaModel() {
        return JavaParserMetaModel.recordPatternExprMetaModel;
    }

    public RecordPatternExpr(TokenRange tokenRange, NodeList<Modifier> modifiers, Type type, NodeList<PatternExpr> patternList) {
        super(tokenRange, type);
        this.setModifiers((NodeList)modifiers);
        this.setPatternList(patternList);
        this.customInitialization();
    }
}

