/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.ast.expr;

import java.util.Optional;
import java.util.function.Consumer;
import org.moditect.internal.shaded.javaparser.TokenRange;
import org.moditect.internal.shaded.javaparser.ast.AllFieldsConstructor;
import org.moditect.internal.shaded.javaparser.ast.Modifier;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.ast.NodeList;
import org.moditect.internal.shaded.javaparser.ast.expr.PatternExpr;
import org.moditect.internal.shaded.javaparser.ast.expr.SimpleName;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.NodeWithSimpleName;
import org.moditect.internal.shaded.javaparser.ast.nodeTypes.modifiers.NodeWithFinalModifier;
import org.moditect.internal.shaded.javaparser.ast.observer.ObservableProperty;
import org.moditect.internal.shaded.javaparser.ast.type.ClassOrInterfaceType;
import org.moditect.internal.shaded.javaparser.ast.type.Type;
import org.moditect.internal.shaded.javaparser.ast.visitor.CloneVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.GenericVisitor;
import org.moditect.internal.shaded.javaparser.ast.visitor.VoidVisitor;
import org.moditect.internal.shaded.javaparser.metamodel.JavaParserMetaModel;
import org.moditect.internal.shaded.javaparser.metamodel.TypePatternExprMetaModel;
import org.moditect.internal.shaded.javaparser.utils.Utils;

public class TypePatternExpr
extends PatternExpr
implements NodeWithSimpleName<TypePatternExpr>,
NodeWithFinalModifier<TypePatternExpr> {
    private NodeList<Modifier> modifiers;
    private SimpleName name;

    public TypePatternExpr() {
        this(null, new NodeList<Modifier>(), new ClassOrInterfaceType(), new SimpleName());
    }

    @AllFieldsConstructor
    public TypePatternExpr(NodeList<Modifier> modifiers, Type type, SimpleName name) {
        this(null, modifiers, type, name);
    }

    public TypePatternExpr(TokenRange tokenRange, NodeList<Modifier> modifiers, Type type, SimpleName name) {
        super(tokenRange, type);
        this.setModifiers((NodeList)modifiers);
        this.setName(name);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public TypePatternExpr setName(SimpleName name) {
        Utils.assertNotNull(name);
        if (name == this.name) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.NAME, this.name, name);
        if (this.name != null) {
            this.name.setParentNode(null);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
        return this;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.modifiers.size(); ++i) {
            if (this.modifiers.get(i) != node) continue;
            this.modifiers.set(i, (Modifier)replacementNode);
            return true;
        }
        if (node == this.name) {
            this.setName((SimpleName)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public TypePatternExpr clone() {
        return (TypePatternExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public TypePatternExprMetaModel getMetaModel() {
        return JavaParserMetaModel.typePatternExprMetaModel;
    }

    @Override
    public NodeList<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public TypePatternExpr setModifiers(NodeList<Modifier> modifiers) {
        Utils.assertNotNull(modifiers);
        if (modifiers == this.modifiers) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        if (this.modifiers != null) {
            this.modifiers.setParentNode(null);
        }
        this.modifiers = modifiers;
        this.setAsParentNodeOf(modifiers);
        return this;
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < this.modifiers.size(); ++i) {
            if (this.modifiers.get(i) != node) continue;
            this.modifiers.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public boolean isTypePatternExpr() {
        return true;
    }

    @Override
    public TypePatternExpr asTypePatternExpr() {
        return this;
    }

    @Override
    public Optional<TypePatternExpr> toTypePatternExpr() {
        return Optional.of(this);
    }

    @Override
    public void ifTypePatternExpr(Consumer<TypePatternExpr> action) {
        action.accept(this);
    }
}

