/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.ast.validator;

import org.moditect.internal.shaded.javaparser.ast.expr.Name;
import org.moditect.internal.shaded.javaparser.ast.expr.SimpleName;
import org.moditect.internal.shaded.javaparser.ast.validator.ProblemReporter;
import org.moditect.internal.shaded.javaparser.ast.validator.VisitorValidator;
import org.moditect.internal.shaded.javaparser.utils.CodeGenerationUtils;

public class ReservedKeywordValidator
extends VisitorValidator {
    private final String keyword;
    private final String error;

    public ReservedKeywordValidator(String keyword) {
        this.keyword = keyword;
        this.error = CodeGenerationUtils.f("'%s' cannot be used as an identifier as it is a keyword.", keyword);
    }

    @Override
    public void visit(Name n, ProblemReporter arg) {
        if (n.getIdentifier().equals(this.keyword)) {
            arg.report(n, this.error, new Object[0]);
        }
        super.visit(n, arg);
    }

    @Override
    public void visit(SimpleName n, ProblemReporter arg) {
        if (n.getIdentifier().equals(this.keyword)) {
            arg.report(n, this.error, new Object[0]);
        }
        super.visit(n, arg);
    }
}

