/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.printer.concretesyntaxmodel;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.printer.SourcePrinter;
import org.moditect.internal.shaded.javaparser.printer.concretesyntaxmodel.CsmElement;

public class CsmSequence
implements CsmElement {
    private List<CsmElement> elements;

    public CsmSequence(List<CsmElement> elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        if (elements.stream().anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException("Null element in the sequence");
        }
        this.elements = elements;
    }

    public List<CsmElement> getElements() {
        return this.elements;
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        this.elements.forEach(e -> e.prettyPrint(node, printer));
    }

    public String toString() {
        return this.elements.stream().map(e -> e.toString()).collect(Collectors.joining(",", "CsmSequence[", "]"));
    }
}

