/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.internal.shaded.javaparser.printer.lexicalpreservation;

import java.util.Optional;
import org.moditect.internal.shaded.javaparser.JavaToken;
import org.moditect.internal.shaded.javaparser.Range;
import org.moditect.internal.shaded.javaparser.ast.Node;
import org.moditect.internal.shaded.javaparser.printer.lexicalpreservation.LexicalPreservingVisitor;
import org.moditect.internal.shaded.javaparser.printer.lexicalpreservation.TextElement;

public class TokenTextElement
extends TextElement {
    private final JavaToken token;

    TokenTextElement(JavaToken token) {
        this.token = token;
    }

    TokenTextElement(int tokenKind, String text) {
        this(new JavaToken(tokenKind, text));
    }

    TokenTextElement(int tokenKind) {
        this(new JavaToken(tokenKind));
    }

    @Override
    public String expand() {
        return this.token.getText();
    }

    public String getText() {
        return this.token.getText();
    }

    public int getTokenKind() {
        return this.token.getKind();
    }

    public JavaToken getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenTextElement that = (TokenTextElement)o;
        return this.token.equals(that.token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public String toString() {
        return this.token.toString();
    }

    @Override
    boolean isToken(int tokenKind) {
        return this.token.getKind() == tokenKind;
    }

    @Override
    boolean isNode(Node node) {
        return false;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.token.getCategory().isWhitespace();
    }

    @Override
    public boolean isSpaceOrTab() {
        return this.token.getCategory().isWhitespaceButNotEndOfLine();
    }

    @Override
    public boolean isComment() {
        return this.token.getCategory().isComment();
    }

    @Override
    public boolean isSeparator() {
        return this.token.getCategory().isSeparator();
    }

    @Override
    public boolean isNewline() {
        return this.token.getCategory().isEndOfLine();
    }

    @Override
    public boolean isChildOfClass(Class<? extends Node> nodeClass) {
        return false;
    }

    @Override
    public boolean isIdentifier() {
        return this.getToken().getCategory().isIdentifier();
    }

    @Override
    public boolean isKeyword() {
        return this.getToken().getCategory().isKeyword();
    }

    @Override
    public boolean isLiteral() {
        return this.getToken().getCategory().isLiteral();
    }

    @Override
    public boolean isPrimitive() {
        return JavaToken.Kind.valueOf(this.getTokenKind()).isPrimitive();
    }

    @Override
    Optional<Range> getRange() {
        return this.token.getRange();
    }

    @Override
    public void accept(LexicalPreservingVisitor visitor) {
        visitor.visit(this);
    }
}

