/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerType;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.internal.connection.ConnectionPool;
import com.mongodb.internal.connection.EventHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.ServerDescriptionChangedListener;
import com.mongodb.internal.connection.ServerDescriptionHelper;
import com.mongodb.internal.connection.ServerMonitor;
import com.mongodb.internal.connection.ServerTypeHelper;
import com.mongodb.internal.connection.TopologyVersionHelper;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@ThreadSafe
final class DefaultSdamServerDescriptionManager
implements SdamServerDescriptionManager {
    private final ServerId serverId;
    private final ServerDescriptionChangedListener serverDescriptionChangedListener;
    private final ServerListener serverListener;
    private final ServerMonitor serverMonitor;
    private final ConnectionPool connectionPool;
    private final ClusterConnectionMode connectionMode;
    private final Lock lock;
    private volatile ServerDescription description;

    DefaultSdamServerDescriptionManager(ServerId serverId, ServerDescriptionChangedListener serverDescriptionChangedListener, ServerListener serverListener, ServerMonitor serverMonitor, ConnectionPool connectionPool, ClusterConnectionMode connectionMode) {
        this.serverId = Assertions.assertNotNull(serverId);
        this.serverDescriptionChangedListener = Assertions.assertNotNull(serverDescriptionChangedListener);
        this.serverListener = Assertions.assertNotNull(serverListener);
        this.serverMonitor = Assertions.assertNotNull(serverMonitor);
        this.connectionPool = Assertions.assertNotNull(connectionPool);
        this.connectionMode = Assertions.assertNotNull(connectionMode);
        this.description = ServerDescriptionHelper.unknownConnectingServerDescription(serverId, null);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ServerDescription candidateDescription) {
        this.lock.lock();
        try {
            if (TopologyVersionHelper.newer(this.description.getTopologyVersion(), candidateDescription.getTopologyVersion())) {
                return;
            }
            ServerType newServerType = candidateDescription.getType();
            boolean markedPoolReady = false;
            if (ServerTypeHelper.isDataBearing(newServerType) || newServerType != ServerType.UNKNOWN && this.connectionMode == ClusterConnectionMode.SINGLE) {
                this.connectionPool.ready();
                markedPoolReady = true;
            }
            this.updateDescription(candidateDescription);
            if (candidateDescription.getException() != null) {
                Assertions.assertTrue(newServerType == ServerType.UNKNOWN);
                Assertions.assertFalse(markedPoolReady);
                this.connectionPool.invalidate();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void handleExceptionBeforeHandshake(SdamServerDescriptionManager.SdamIssue sdamIssue) {
        this.lock.lock();
        try {
            this.handleException(sdamIssue, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue sdamIssue) {
        this.lock.lock();
        try {
            this.handleException(sdamIssue, false);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SdamServerDescriptionManager.SdamIssue.Context context() {
        return new SdamServerDescriptionManager.SdamIssue.Context(this.serverId, this.connectionPool.getGeneration(), this.description.getMaxWireVersion());
    }

    @Override
    public SdamServerDescriptionManager.SdamIssue.Context context(InternalConnection connection) {
        return new SdamServerDescriptionManager.SdamIssue.Context(this.serverId, connection.getGeneration(), connection.getDescription().getMaxWireVersion());
    }

    private void updateDescription(ServerDescription newDescription) {
        ServerDescription previousDescription = this.description;
        this.description = newDescription;
        ServerDescriptionChangedEvent serverDescriptionChangedEvent = new ServerDescriptionChangedEvent(this.serverId, newDescription, previousDescription);
        this.serverDescriptionChangedListener.serverDescriptionChanged(serverDescriptionChangedEvent);
        if (!EventHelper.wouldDescriptionsGenerateEquivalentEvents(newDescription, previousDescription)) {
            this.serverListener.serverDescriptionChanged(serverDescriptionChangedEvent);
        }
    }

    private void handleException(SdamServerDescriptionManager.SdamIssue sdamIssue, boolean beforeHandshake) {
        if (sdamIssue.stale(this.connectionPool, this.description)) {
            return;
        }
        if (sdamIssue.relatedToStateChange()) {
            this.updateDescription(sdamIssue.serverDescription());
            if (sdamIssue.serverIsLessThanVersionFourDotTwo() || sdamIssue.relatedToShutdown()) {
                this.connectionPool.invalidate(sdamIssue.exception().orElse(null));
            }
            this.serverMonitor.connect();
        } else if (sdamIssue.relatedToNetworkNotTimeout() || beforeHandshake && (sdamIssue.relatedToNetworkTimeout() || sdamIssue.relatedToAuth())) {
            this.updateDescription(sdamIssue.serverDescription());
            this.connectionPool.invalidate(sdamIssue.exception().orElse(null));
            this.serverMonitor.cancelCurrentCheck();
        } else if (sdamIssue.relatedToWriteConcern() || !sdamIssue.specific()) {
            this.updateDescription(sdamIssue.serverDescription());
            if (sdamIssue.serverIsLessThanVersionFourDotTwo()) {
                this.connectionPool.invalidate(sdamIssue.exception().orElse(null));
            }
            this.serverMonitor.connect();
        }
    }
}

