/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class FragmentCollector {
    List<String> fragments = new ArrayList<String>();
    Map<String, Object> parameters = new HashMap<String, Object>();

    FragmentCollector() {
    }

    private FragmentCollector(FragmentAndParameters initialFragment) {
        this.add(initialFragment);
    }

    public void add(FragmentAndParameters fragmentAndParameters) {
        this.fragments.add(fragmentAndParameters.fragment());
        this.parameters.putAll(fragmentAndParameters.parameters());
    }

    public FragmentCollector merge(FragmentCollector other) {
        this.fragments.addAll(other.fragments);
        this.parameters.putAll(other.parameters);
        return this;
    }

    public Stream<String> fragments() {
        return this.fragments.stream();
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public boolean hasMultipleFragments() {
        return this.fragments.size() > 1;
    }

    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    public static Collector<FragmentAndParameters, FragmentCollector, FragmentCollector> collect() {
        return Collector.of(FragmentCollector::new, FragmentCollector::add, FragmentCollector::merge, new Collector.Characteristics[0]);
    }

    public static Collector<FragmentAndParameters, FragmentCollector, FragmentCollector> collect(FragmentAndParameters initialFragment) {
        return Collector.of(() -> new FragmentCollector(initialFragment), FragmentCollector::add, FragmentCollector::merge, new Collector.Characteristics[0]);
    }
}

