/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class FluxDefaultIfEmpty<T>
extends FluxOperator<T, T> {
    final T value;

    FluxDefaultIfEmpty(Flux<? extends T> source, T value) {
        super(source);
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new DefaultIfEmptySubscriber<T>(actual, this.value));
    }

    static final class DefaultIfEmptySubscriber<T>
    extends Operators.MonoSubscriber<T, T> {
        Subscription s;
        boolean hasValue;

        DefaultIfEmptySubscriber(CoreSubscriber<? super T> actual, T value) {
            super(actual);
            this.value = value;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void request(long n) {
            super.request(n);
            this.s.request(n);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.actual.onNext(t);
        }

        @Override
        public void onComplete() {
            if (this.hasValue) {
                this.actual.onComplete();
            } else {
                this.complete(this.value);
            }
        }

        @Override
        public void setValue(T value) {
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }
    }
}

