/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.function.Function;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxExpand;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxFromMonoOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.reactivestreams.Publisher;

final class MonoExpand<T>
extends FluxFromMonoOperator<T, T> {
    final boolean breadthFirst;
    final Function<? super T, ? extends Publisher<? extends T>> expander;
    final int capacityHint;

    MonoExpand(Mono<T> source, Function<? super T, ? extends Publisher<? extends T>> expander, boolean breadthFirst, int capacityHint) {
        super(source);
        this.expander = expander;
        this.breadthFirst = breadthFirst;
        this.capacityHint = capacityHint;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> s) {
        if (this.breadthFirst) {
            FluxExpand.ExpandBreathSubscriber<T> parent = new FluxExpand.ExpandBreathSubscriber<T>(s, this.expander, this.capacityHint);
            parent.queue.offer(this.source);
            s.onSubscribe(parent);
            parent.drainQueue();
        } else {
            FluxExpand.ExpandDepthSubscription<? super T> parent = new FluxExpand.ExpandDepthSubscription<T>(s, this.expander, this.capacityHint);
            parent.source = this.source;
            s.onSubscribe(parent);
        }
    }
}

