/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.noear.folkmq.broker.MqDraft;
import org.noear.folkmq.broker.MqNextTime;
import org.noear.folkmq.common.MqMetasResolver;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.MessageBuilder;

public class MqMessageHolder
implements Delayed {
    public final MqMetasResolver mr;
    private final MqDraft draft;
    private final EntityDefault entity;
    private boolean transaction;
    private volatile long distributeTime;
    private volatile long distributeTimeRef;
    private volatile int distributeCount;
    private volatile int distributeCountPre;
    private volatile long distributeIdx;
    private final String queueName;
    private AtomicBoolean isDone;
    private long id;

    public MqMessageHolder(MqDraft draft, String queueName, String consumerGroup) {
        this.draft = draft;
        this.mr = draft.mr;
        this.entity = new EntityDefault().dataSet(this.draft.source.data()).metaMapPut(this.draft.source.metaMap());
        this.mr.setConsumerGroup((Entity)this.entity, consumerGroup);
        this.isDone = new AtomicBoolean();
        this.transaction = this.draft.transaction;
        this.distributeCountPre = this.distributeCount = this.draft.times;
        this.distributeTime = this.distributeTimeRef = this.draft.scheduled;
        this.queueName = queueName;
        if (this.draft.sequence) {
            this.entity.at(queueName + "!");
        } else {
            this.entity.at(queueName);
        }
        if (this.transaction) {
            this.entity.at(this.draft.sender);
        }
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getSender() {
        return this.draft.sender;
    }

    public String getAtName() {
        return this.draft.atName;
    }

    public String getKey() {
        return this.draft.key;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public EntityDefault getEntity() {
        return this.entity;
    }

    public int getQos() {
        return this.draft.qos;
    }

    public long getExpiration() {
        return this.draft.expiration;
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public Message noTransaction() {
        this.transaction = false;
        this.distributeCountPre = 0;
        this.distributeCount = 0;
        this.distributeTime = this.distributeTimeRef = System.currentTimeMillis();
        this.mr.setTimes((Entity)this.entity, 0);
        this.mr.bakScheduled((Entity)this.entity, false);
        this.mr.bakExpiration((Entity)this.entity, false);
        this.mr.setTransaction((Entity)this.entity, false);
        return new MessageBuilder().sid(this.getKey()).entity((Entity)this.getEntity()).build();
    }

    public boolean isBroadcast() {
        return this.draft.broadcast;
    }

    public boolean isSequence() {
        return this.draft.sequence;
    }

    public String getSequenceSharding() {
        return this.draft.sequenceSharding;
    }

    public void setDistributeTime(long distributeTime) {
        this.distributeTimeRef = distributeTime;
        if (!this.isSequence()) {
            this.distributeTime = this.distributeTimeRef;
        }
    }

    public void setDistributeIdx(long distributeIdx) {
        this.distributeIdx = distributeIdx;
    }

    public long getDistributeTime() {
        return this.distributeTime;
    }

    public long getDistributeTimeRef() {
        return this.distributeTimeRef;
    }

    public int getDistributeCount() {
        return this.distributeCount;
    }

    public int getDistributeCountPre() {
        return this.distributeCountPre;
    }

    public boolean isDone() {
        return this.isDone.get();
    }

    public void setDone(boolean done) {
        this.isDone.set(done);
    }

    public MqMessageHolder preDelayed(long distributeTime) {
        ++this.distributeCountPre;
        this.setDistributeTime(distributeTime);
        return this;
    }

    public MqMessageHolder delayed() {
        return this.delayed(MqNextTime.getNextTime(this.distributeCount + 1));
    }

    public MqMessageHolder delayed(long newTime) {
        ++this.distributeCount;
        this.distributeCountPre = this.distributeCount;
        this.distributeTimeRef = newTime;
        this.mr.setTimes((Entity)this.entity, this.distributeCount);
        if (!this.isSequence()) {
            this.distributeTime = this.distributeTimeRef;
            this.mr.setScheduled((Entity)this.entity, this.distributeTimeRef);
        }
        return this;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long duration = this.distributeTime - System.currentTimeMillis();
        return unit.convert(duration, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (this == o) {
            return 0;
        }
        MqMessageHolder dst = (MqMessageHolder)o;
        long diff = this.distributeTime - dst.distributeTime;
        if (diff == 0L) {
            if (this.distributeIdx < dst.distributeIdx) {
                return -1;
            }
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 1;
    }
}

