/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker;

import java.util.concurrent.atomic.AtomicLong;

public class MqQps {
    private transient long startTime = System.currentTimeMillis();
    private transient AtomicLong counter = new AtomicLong();
    private long lastValue;
    private long maxValue;

    public long getLastValue() {
        return this.lastValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void record() {
        this.counter.incrementAndGet();
    }

    public void reset() {
        long counterVal = this.counter.longValue();
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long elapsedSeconds = elapsedTime / 1000L;
        this.lastValue = counterVal / elapsedSeconds;
        if (this.lastValue > this.maxValue) {
            this.maxValue = this.lastValue;
        }
        this.startTime = System.currentTimeMillis();
        this.counter.set(0L);
    }
}

