/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.folkmq.broker.MqMessageHolder;
import org.noear.folkmq.broker.MqMessageHolderMap;
import org.noear.folkmq.broker.MqMessageHolderQueue;
import org.noear.folkmq.broker.MqQueue;
import org.noear.socketd.cluster.LoadBalancer;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.utils.StrUtils;

public abstract class MqQueueBase
implements MqQueue {
    protected final MqMessageHolderMap messageMap;
    protected final MqMessageHolderQueue messageQueue;
    protected final AtomicLong messageDistributeTime = new AtomicLong(0L);
    protected final AtomicLong messageIndexer = new AtomicLong();
    protected final ReentrantLock messageAddLock = new ReentrantLock(true);
    private final List<Session> consumerSessions = new CopyOnWriteArrayList<Session>();

    public MqQueueBase() {
        this.messageMap = new MqMessageHolderMap();
        this.messageQueue = new MqMessageHolderQueue();
    }

    public long messageCount(int n) {
        return this.messageQueue.countGet(n);
    }

    @Override
    public int sessionCount() {
        return this.consumerSessions.size();
    }

    @Override
    public void sessionAdd(Session session) {
        if (!this.consumerSessions.contains(session)) {
            this.consumerSessions.add(session);
        }
    }

    @Override
    public void sessionRemove(Session session) {
        this.consumerSessions.remove(session);
    }

    @Override
    public Collection<Session> sessionAll() {
        return this.consumerSessions;
    }

    protected Session sessionGetOne(MqMessageHolder messageHolder) {
        if (messageHolder.isSequence()) {
            if (StrUtils.isEmpty((String)messageHolder.getSequenceSharding())) {
                return (Session)LoadBalancer.getAnyByHash(this.consumerSessions, (String)this.getTopic());
            }
            return (Session)LoadBalancer.getAnyByHash(this.consumerSessions, (String)messageHolder.getSequenceSharding());
        }
        return (Session)LoadBalancer.getAnyByPoll(this.consumerSessions);
    }

    @Override
    public int messageTotal() {
        return this.messageMap.size();
    }

    @Override
    public int messageTotal2() {
        return this.messageQueue.size();
    }

    @Override
    public void close() {
        this.consumerSessions.clear();
        this.messageQueue.clear();
        this.messageMap.clear();
    }
}

