/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.noear.folkmq.client.MqConsumeHandler;
import org.noear.folkmq.client.MqMessage;
import org.noear.folkmq.client.MqTransaction;
import org.noear.folkmq.client.MqTransactionCheckback;
import org.noear.socketd.transport.client.ClientConfigHandler;
import org.noear.socketd.transport.stream.RequestStream;
import org.noear.socketd.utils.StrUtils;

public interface MqClient {
    public String name();

    public MqClient nameAs(String var1);

    public String namespace();

    public MqClient namespaceAs(String var1);

    public MqClient connect() throws IOException;

    public void disconnect() throws IOException;

    public MqClient config(ClientConfigHandler var1);

    public MqClient consumeExecutor(ExecutorService var1);

    public MqClient autoAcknowledge(boolean var1);

    public boolean autoAcknowledge();

    public CompletableFuture<String> call(String var1, String var2, String var3, String var4) throws IOException;

    public void subscribe(String var1, String var2, boolean var3, MqConsumeHandler var4) throws IOException;

    default public void subscribe(String topic, String consumerGroup, MqConsumeHandler consumerHandler) throws IOException {
        this.subscribe(topic, consumerGroup, this.autoAcknowledge(), consumerHandler);
    }

    default public void subscribe(String topic, MqConsumeHandler consumerHandler) throws IOException {
        if (StrUtils.isEmpty((String)this.name())) {
            throw new IllegalArgumentException("Client 'name' can't be empty");
        }
        this.subscribe(topic, this.name(), this.autoAcknowledge(), consumerHandler);
    }

    public void unsubscribe(String var1, String var2) throws IOException;

    default public void unsubscribe(String topic) throws IOException {
        if (StrUtils.isEmpty((String)this.name())) {
            throw new IllegalArgumentException("Client 'name' can't be empty");
        }
        this.unsubscribe(topic, this.name());
    }

    public void publish(String var1, MqMessage var2) throws IOException;

    public CompletableFuture<Boolean> publishAsync(String var1, MqMessage var2) throws IOException;

    public void unpublish(String var1, String var2) throws IOException;

    public CompletableFuture<Boolean> unpublishAsync(String var1, String var2) throws IOException;

    public void listen(MqConsumeHandler var1);

    public RequestStream send(MqMessage var1, String var2, long var3) throws IOException;

    default public RequestStream send(MqMessage message, String toName) throws IOException {
        return this.send(message, toName, 0L);
    }

    public MqClient transactionCheckback(MqTransactionCheckback var1);

    public MqTransaction newTransaction();
}

