/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.client;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.noear.folkmq.client.MqMessageBase;
import org.noear.folkmq.client.MqTransaction;
import org.noear.folkmq.common.MqAssert;
import org.noear.socketd.utils.StrUtils;

public class MqMessage
implements MqMessageBase {
    private final String key;
    private final byte[] body;
    private String sender;
    private String tag;
    private Date scheduled;
    private Date expiration;
    private boolean broadcast;
    private boolean sequence;
    private String sequenceSharding;
    private int qos = 1;
    private Map<String, String> attrMap = new HashMap<String, String>();
    protected MqTransaction transaction;

    public MqMessage(String body) {
        this(body, null);
    }

    public MqMessage(byte[] body) {
        this(body, null);
    }

    public MqMessage(String body, String key) {
        this(body.getBytes(StandardCharsets.UTF_8), key);
    }

    public MqMessage(byte[] body, String key) {
        MqAssert.requireNonNull(body, "Param 'body' can't be null");
        this.key = StrUtils.isEmpty((String)key) ? StrUtils.guid() : key;
        this.body = body;
    }

    @Override
    public String getSender() {
        return this.sender;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    public Date getScheduled() {
        return this.scheduled;
    }

    @Override
    public Date getExpiration() {
        return this.expiration;
    }

    @Override
    public boolean isTransaction() {
        return this.transaction != null;
    }

    @Override
    public boolean isBroadcast() {
        return this.broadcast;
    }

    @Override
    public boolean isSequence() {
        return this.sequence;
    }

    public String getSequenceSharding() {
        return this.sequenceSharding;
    }

    @Override
    public int getQos() {
        return this.qos;
    }

    public MqMessage tag(String tag) {
        this.tag = tag;
        return this;
    }

    public MqMessage asJson() {
        this.attr("Content-Type", "application/json");
        return this;
    }

    public MqMessage scheduled(Date scheduled) {
        this.scheduled = scheduled;
        return this;
    }

    public MqMessage expiration(Date expiration) {
        this.expiration = expiration;
        return this;
    }

    public MqMessage transaction(MqTransaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
            transaction.binding(this);
        }
        return this;
    }

    public MqMessage broadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    protected String getTmid() {
        if (this.transaction == null) {
            return null;
        }
        return this.transaction.tmid();
    }

    protected MqMessage internalSender(String sender) {
        this.sender = sender;
        return this;
    }

    public MqMessage sequence(boolean sequence) {
        this.sequence = sequence;
        return this;
    }

    public MqMessage sequence(boolean sequence, String sharding) {
        this.sequence = sequence;
        this.sequenceSharding = sequence ? sharding : null;
        return this;
    }

    public MqMessage qos(int qos) {
        this.qos = qos;
        return this;
    }

    @Override
    public String getAttr(String name) {
        return this.attrMap.get(name);
    }

    @Override
    public Map<String, String> getAttrMap() {
        return Collections.unmodifiableMap(this.attrMap);
    }

    public MqMessage attr(String name, String value) {
        MqAssert.assertMeta(name, "name");
        MqAssert.assertMeta(value, "value");
        this.attrMap.put(name, value);
        return this;
    }
}

