/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker.embedded;

import java.util.Collections;
import java.util.Map;
import org.noear.folkmq.broker.embedded.mq.FolkmqLifecycleBean;
import org.noear.socketd.utils.StrUtils;
import org.noear.solon.Solon;
import org.noear.solon.core.util.PathUtil;

public class MqBrokerConfig {
    public static final String path = Solon.cfg().get("folkmq.path");
    public static final String displayPath;
    public static final String accessAk;
    public static final String accessSk;
    public static final String apiToken;
    public static final int ioThreads;
    public static final int codecThreads;
    public static final int exchangeThreads;
    public static final long streamTimeout;
    public static final boolean saveEnable;
    public static final long save900;
    public static final long save300;
    public static final long save100;
    public static final String proxyServer;
    public static final int folkmqTransportPort;

    public static boolean isStandalone() {
        return FolkmqLifecycleBean.isStandalone();
    }

    public static Map<String, String> getAccessMap() {
        Map accessMap = Solon.cfg().getMap("folkmq.access.");
        accessMap.remove("ak");
        accessMap.remove("sk");
        String ak = Solon.cfg().get("folkmq.access.ak");
        String sk = Solon.cfg().get("folkmq.access.sk");
        if (StrUtils.isNotEmpty((String)ak)) {
            accessMap.put(ak, sk);
        }
        return Collections.unmodifiableMap(accessMap);
    }

    static {
        String displayPathStr = PathUtil.mergePath((String)Solon.cfg().serverContextPath(), (String)path);
        displayPath = displayPathStr.endsWith("/") ? displayPathStr.substring(0, displayPathStr.length() - 1) : displayPathStr;
        String proxyServerTmp = Solon.cfg().get("folkmq.proxy");
        proxyServer = StrUtils.isEmpty((String)proxyServerTmp) ? Solon.cfg().get("folkmq.broker") : proxyServerTmp;
        folkmqTransportPort = Solon.cfg().getInt("folkmq.transport.port", 0);
        saveEnable = Solon.cfg().getBool("folkmq.snapshot.enable", true);
        save900 = Solon.cfg().getLong("folkmq.snapshot.save900", 0L);
        save300 = Solon.cfg().getLong("folkmq.snapshot.save300", 0L);
        save100 = Solon.cfg().getLong("folkmq.snapshot.save100", 0L);
        accessAk = Solon.cfg().get("folkmq.access.ak");
        accessSk = Solon.cfg().get("folkmq.access.sk");
        apiToken = Solon.cfg().get("folkmq.api.token", "");
        ioThreads = Solon.cfg().getInt("folkmq.ioThreads", 1);
        codecThreads = Solon.cfg().getInt("folkmq.codecThreads", 1);
        exchangeThreads = Solon.cfg().getInt("folkmq.exchangeThreads", 1);
        streamTimeout = Solon.cfg().getLong("folkmq.streamTimeout", 300000L);
    }
}

