/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker.embedded.admin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.noear.folkmq.broker.MqBorkerInternal;
import org.noear.folkmq.broker.embedded.admin.BaseController;
import org.noear.folkmq.broker.embedded.admin.model.TopicVo;
import org.noear.folkmq.client.MqMessage;
import org.noear.folkmq.common.MqUtils;
import org.noear.snack.core.utils.DateUtil;
import org.noear.socketd.transport.core.Message;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.annotation.Logined;
import org.noear.solon.validation.annotation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Logined
@Valid
public class AdminController
extends BaseController {
    static final Logger log = LoggerFactory.getLogger(AdminController.class);
    @Inject
    MqBorkerInternal serviceInternal;

    @Mapping(value="/admin")
    public ModelAndView admin() {
        return this.view("admin");
    }

    @Mapping(value="/admin/stat")
    public ModelAndView stat() {
        ModelAndView mv = this.view("admin_stat");
        mv.put("qpsInput", (Object)this.serviceInternal.getQpsPublish());
        mv.put("qpsOutput", (Object)this.serviceInternal.getQpsDistribute());
        return mv;
    }

    @Mapping(value="/admin/topic")
    public ModelAndView topic() {
        Iterator iterator = this.serviceInternal.getSubscribeMap().entrySet().iterator();
        ArrayList<TopicVo> list = new ArrayList<TopicVo>();
        while (iterator.hasNext()) {
            Map.Entry kv = iterator.next();
            String topic = (String)kv.getKey();
            Set queueSet = (Set)kv.getValue();
            TopicVo topicVo = new TopicVo();
            topicVo.setTopic(topic);
            if (queueSet != null) {
                topicVo.setQueueCount(queueSet.size());
                topicVo.setQueueList(queueSet.toString());
            } else {
                topicVo.setQueueCount(0);
                topicVo.setQueueList("");
            }
            list.add(topicVo);
            if (list.size() != 99) continue;
            break;
        }
        list.sort(Comparator.comparing(TopicVo::getTopic));
        return this.view("admin_topic").put("list", list);
    }

    @Mapping(value="/admin/publish")
    public ModelAndView publish() {
        return this.view("admin_publish");
    }

    @Mapping(value="/admin/publish/ajax/post")
    public Result publish_ajax_post(String topic, String scheduled, int qos, String content) {
        try {
            if (this.serviceInternal.hasSubscribe(topic)) {
                Date scheduledDate = DateUtil.parse((String)scheduled);
                MqMessage message = new MqMessage(content).qos(qos).scheduled(scheduledDate);
                Message routingMessage = MqUtils.getLast().routingMessageBuild(topic, message);
                this.serviceInternal.routingDo(MqUtils.getLast(), routingMessage);
                return Result.succeed();
            }
            return Result.failure((String)"\u4e3b\u9898\u4e0d\u5b58\u5728!");
        }
        catch (Exception e) {
            return Result.failure((String)e.getLocalizedMessage());
        }
    }
}

