/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker.embedded.admin;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.noear.folkmq.broker.embedded.admin.BaseController;
import org.noear.folkmq.broker.embedded.admin.utils.ImageUtils;
import org.noear.folkmq.broker.embedded.admin.utils.RandomUtils;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Post;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoginController
extends BaseController {
    static final Logger log = LoggerFactory.getLogger(LoginController.class);
    private final String adminPassword = Solon.cfg().get("folkmq.admin", "");
    private final String adminUser = "admin";

    @Mapping(value="/")
    public void home(Context ctx) throws Exception {
        ctx.redirect("./login");
    }

    @Mapping(value="/login")
    public ModelAndView login(Context ctx) throws Throwable {
        ctx.sessionClear();
        return this.view("login");
    }

    @Post
    @Mapping(value="/login/ajax/check")
    public Result login_ajax_check(Context ctx, String userName, String passWord, String captcha) throws Exception {
        if (Utils.isEmpty((String)captcha)) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801\uff01");
        }
        if (Utils.isEmpty((String)userName) || Utils.isEmpty((String)passWord)) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u8bf7\u8f93\u5165\u8d26\u53f7\u548c\u5bc6\u7801\uff01");
        }
        MDC.put((String)"tag1", (String)ctx.path());
        MDC.put((String)"tag2", (String)userName);
        String captchaOfSessoin = (String)ctx.sessionOrDefault("Validation_String", (Object)"");
        if (!captcha.equalsIgnoreCase(captchaOfSessoin)) {
            return Result.failure((String)"\u63d0\u793a\uff1a\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        if ("admin".equals(userName) && this.adminPassword.equals(passWord)) {
            ctx.sessionSet("Logined", (Object)"1");
            return Result.succeed((Object)"./admin");
        }
        return Result.failure((String)"\u63d0\u793a\uff1a\u8d26\u53f7\u6216\u5bc6\u7801\u4e0d\u5bf9\uff01");
    }

    @Mapping(value="/login/validation/img", method={MethodType.GET}, produces="image/jpeg")
    public void getValidationImg(Context ctx) throws IOException {
        String code = RandomUtils.code(4);
        ctx.sessionSet("Validation_String", (Object)code);
        ctx.sessionState().sessionPublish();
        BufferedImage bufferedImage = ImageUtils.getValidationImage(code);
        ctx.headerSet("Pragma", "no-cache");
        ctx.headerSet("Cache-Control", "no-cache");
        ctx.headerSet("Expires", "0");
        ImageIO.setUseCache(false);
        ImageIO.write((RenderedImage)bufferedImage, "jpeg", ctx.outputStream());
    }
}

