/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker.embedded.mq;

import java.io.IOException;
import java.util.List;
import org.noear.folkmq.broker.MqBorkerInternal;
import org.noear.folkmq.broker.MqBorkerListener;
import org.noear.folkmq.broker.embedded.MqBrokerConfig;
import org.noear.folkmq.broker.embedded.admin.dso.QueueForceService;
import org.noear.folkmq.broker.embedded.admin.dso.ViewUtils;
import org.noear.folkmq.broker.embedded.admin.model.QueueVo;
import org.noear.snack.ONode;
import org.noear.socketd.transport.core.Entity;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.entity.StringEntity;
import org.noear.socketd.transport.core.listener.MessageHandler;
import org.noear.socketd.utils.StrUtils;
import org.noear.solon.core.handle.Result;

public class FolkmqApiHandler
implements MessageHandler {
    private MqBorkerListener serviceListener;
    private QueueForceService queueForceService;

    public FolkmqApiHandler(QueueForceService queueForceService, MqBorkerListener serviceListener) {
        this.queueForceService = queueForceService;
        this.serviceListener = serviceListener;
    }

    public void handle(Session s, Message m) throws IOException {
        String name = m.meta("api.name");
        String token = m.meta("api.token");
        if (StrUtils.isEmpty((String)MqBrokerConfig.apiToken)) {
            s.sendAlarm(m, "Api calls are not supported");
            return;
        }
        if (!MqBrokerConfig.apiToken.equals(token)) {
            s.sendAlarm(m, "Token is invalid");
            return;
        }
        String topic = m.meta("mq.topic");
        String consumerGroup = m.meta("mq.consumer");
        String queueName = topic + "#" + consumerGroup;
        try {
            if ("mq.queue.list".equals(name)) {
                List<QueueVo> queueVolist = ViewUtils.queueView((MqBorkerInternal)this.serviceListener);
                this.replyDo(s, m, Result.succeed(queueVolist));
                return;
            }
            if ("mq.queue.view.message".equals(name)) {
                QueueVo queueVo = ViewUtils.queueOneView((MqBorkerInternal)this.serviceListener, queueName);
                if (queueVo == null) {
                    this.replyDo(s, m, Result.failure((String)"Queue does not exist"));
                } else {
                    this.replyDo(s, m, Result.succeed((Object)queueVo));
                }
                return;
            }
            if ("mq.queue.view.session".equals(name)) {
                List<String> list = ViewUtils.queueSessionListView((MqBorkerInternal)this.serviceListener, queueName);
                this.replyDo(s, m, Result.succeed(list));
                return;
            }
            if ("mq.queue.force.clear".equals(name)) {
                this.queueForceService.forceClear((MqBorkerInternal)this.serviceListener, topic, consumerGroup, MqBrokerConfig.isStandalone());
                this.replyDo(s, m, Result.succeed());
                return;
            }
            if ("mq.queue.force.delete".equals(name)) {
                this.queueForceService.forceDelete((MqBorkerInternal)this.serviceListener, topic, consumerGroup, MqBrokerConfig.isStandalone());
                this.replyDo(s, m, Result.succeed());
                return;
            }
            if ("mq.queue.force.distribute".equals(name)) {
                this.queueForceService.forceDelete((MqBorkerInternal)this.serviceListener, topic, consumerGroup, MqBrokerConfig.isStandalone());
                this.replyDo(s, m, Result.succeed());
                return;
            }
        }
        catch (Throwable e) {
            this.replyDo(s, m, Result.failure((String)e.getMessage()));
        }
    }

    private void replyDo(Session s, Message m, Result rst) throws IOException {
        s.replyEnd(m, (Entity)new StringEntity(ONode.stringify((Object)rst)));
    }
}

