/*
 * Decompiled with CFR 0.152.
 */
package org.noear.folkmq.broker.store.fdb;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.LongAdder;
import org.noear.folkmq.broker.MqMessageHolder;
import org.noear.folkmq.broker.store.fdb.MqSnapshotStore;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.utils.RunUtils;

public class MqSnapshotStorePlus
extends MqSnapshotStore {
    private final LongAdder save900Count = new LongAdder();
    private final LongAdder save300Count = new LongAdder();
    private final LongAdder save100Count = new LongAdder();
    private final ScheduledFuture<?> save900Future;
    private final ScheduledFuture<?> save300Future;
    private final ScheduledFuture<?> save100Future;
    protected long save900Condition = 1L;
    protected long save300Condition = 10L;
    protected long save100Condition = 10000L;

    public MqSnapshotStorePlus() {
        this(null);
    }

    public MqSnapshotStorePlus(String dataPath) {
        super(dataPath);
        int fixedDelay900 = 900000;
        this.save900Future = RunUtils.scheduleWithFixedDelay(this::onSave900, (long)fixedDelay900, (long)fixedDelay900);
        int fixedDelay300 = 300000;
        this.save300Future = RunUtils.scheduleWithFixedDelay(this::onSave300, (long)fixedDelay300, (long)fixedDelay300);
        int fixedDelay100 = 100000;
        this.save100Future = RunUtils.scheduleWithFixedDelay(this::onSave100, (long)fixedDelay100, (long)fixedDelay100);
    }

    public MqSnapshotStorePlus save900Condition(long save900Condition) {
        this.save900Condition = save900Condition;
        return this;
    }

    public MqSnapshotStorePlus save300Condition(long save300Condition) {
        this.save300Condition = save300Condition;
        return this;
    }

    public MqSnapshotStorePlus save100Condition(long save100Condition) {
        this.save100Condition = save100Condition;
        return this;
    }

    public long getSave900Count() {
        return this.save900Count.longValue();
    }

    public long getSave300Count() {
        return this.save300Count.longValue();
    }

    public long getSave100Count() {
        return this.save100Count.longValue();
    }

    private void onSave900() {
        long count = this.save900Count.sumThenReset();
        if (this.save900Condition > 1L) {
            if (count >= this.save900Condition) {
                this.onSave();
            } else if (log.isDebugEnabled()) {
                log.debug("No trigger save900 condition!");
            }
        }
    }

    private void onSave300() {
        long count = this.save300Count.sumThenReset();
        if (this.save300Condition > 0L) {
            if (count >= this.save300Condition) {
                this.onSave();
            } else if (log.isDebugEnabled()) {
                log.debug("No trigger save300 condition!");
            }
        }
    }

    private void onSave100() {
        long count = this.save100Count.sumThenReset();
        if (this.save100Condition > 0L) {
            if (count >= this.save100Condition) {
                this.onSave();
            } else if (log.isDebugEnabled()) {
                log.debug("No trigger save100 condition!");
            }
        }
    }

    public void onStopBefore() {
        if (this.save900Future != null) {
            this.save900Future.cancel(false);
        }
        if (this.save300Future != null) {
            this.save300Future.cancel(false);
        }
        if (this.save100Future != null) {
            this.save100Future.cancel(false);
        }
    }

    public void onSubscribe(String topic, String consumerGroup, Session session) {
        super.onSubscribe(topic, consumerGroup, session);
        this.onChange();
    }

    public void onUnSubscribe(String topic, String consumerGroup, Session session) {
        super.onUnSubscribe(topic, consumerGroup, session);
        this.onChange();
    }

    public void onPublish(Message message) {
        super.onPublish(message);
        this.onChange();
    }

    public void onAcknowledge(String topic, String consumerGroup, MqMessageHolder messageHolder, boolean isOk) {
        super.onAcknowledge(topic, consumerGroup, messageHolder, isOk);
        this.onChange();
    }

    private void onChange() {
        this.save900Count.increment();
        this.save300Count.increment();
        this.save100Count.increment();
    }
}

