/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.noear.socketd.transport.core.entity.EntityDefault;
import org.noear.socketd.transport.core.entity.FileEntity;
import org.noear.socketd.transport.core.entity.StringEntity;

public interface Entity {
    public static StringEntity of(String data) {
        return new StringEntity(data);
    }

    public static FileEntity of(File data) throws IOException {
        return new FileEntity(data);
    }

    public static EntityDefault of(byte[] data) {
        return new EntityDefault().dataSet(data);
    }

    public static EntityDefault of(ByteBuffer data) {
        return new EntityDefault().dataSet(data);
    }

    public static EntityDefault of() {
        return new EntityDefault();
    }

    public String metaString();

    public Map<String, String> metaMap();

    public String meta(String var1);

    public String metaOrDefault(String var1, String var2);

    default public int metaAsInt(String name) {
        return Integer.parseInt(this.metaOrDefault(name, "0"));
    }

    default public long metaAsLong(String name) {
        return Long.parseLong(this.metaOrDefault(name, "0"));
    }

    default public float metaAsFloat(String name) {
        return Float.parseFloat(this.metaOrDefault(name, "0"));
    }

    default public double metaAsDouble(String name) {
        return Double.parseDouble(this.metaOrDefault(name, "0"));
    }

    public void putMeta(String var1, String var2);

    public void delMeta(String var1);

    public ByteBuffer data();

    public String dataAsString();

    public byte[] dataAsBytes();

    public int dataSize();

    public void release() throws IOException;
}

