/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.Channel;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Session;

public abstract class SessionBase
implements Session {
    protected final Channel channel;
    private final String sessionId;
    private Map<String, Object> attrMap;

    public SessionBase(Channel channel) {
        this.channel = channel;
        this.sessionId = this.generateId();
    }

    @Override
    public Map<String, Object> attrMap() {
        if (this.attrMap == null) {
            this.attrMap = new ConcurrentHashMap<String, Object>();
        }
        return this.attrMap;
    }

    @Override
    public boolean attrHas(String name) {
        if (this.attrMap == null) {
            return false;
        }
        return this.attrMap.containsKey(name);
    }

    @Override
    public <T> T attr(String name) {
        if (this.attrMap == null) {
            return null;
        }
        return (T)this.attrMap.get(name);
    }

    @Override
    public <T> T attrOrDefault(String name, T def) {
        T tmp = this.attr(name);
        if (tmp == null) {
            return def;
        }
        return tmp;
    }

    @Override
    public <T> Session attrPut(String name, T value) {
        if (this.attrMap == null) {
            this.attrMap = new ConcurrentHashMap<String, Object>();
        }
        this.attrMap.put(name, value);
        return this;
    }

    @Override
    public <T> Session attrDel(String name) {
        if (this.attrMap != null) {
            this.attrMap.remove(name);
        }
        return this;
    }

    @Override
    public Config config() {
        return this.channel.getConfig();
    }

    @Override
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    public boolean isActive() {
        return this.isValid() && !this.isClosing();
    }

    @Override
    public long liveTime() {
        return this.channel.getLiveTime();
    }

    @Override
    public int closeCode() {
        return this.channel.closeCode();
    }

    protected String generateId() {
        return this.channel.getConfig().genId();
    }
}

